import { formatTime } from './index'

const vueFilter = {

  // 将数字转换成带千分位数字
  formatNumber: function (num, precision, separator) {
    var parts;
    if (!isNaN(parseFloat(num)) && isFinite(num)) {
      num = Number(num);
      num = (typeof precision !== 'undefined' ? num.toFixed(precision) : num).toString();
      parts = num.split('.');
      parts[0] = parts[0].toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' + (separator || ','));
      return parts.join('.');
    }
    return '';
  },
  
  // 将数字转换成带千分位数字
  yLocalString: function (value) {
    var b = parseInt(value).toString();
    if (b === 'NaN') return 0;
    var len = b.length;
    if (len <= 3) { return b; }
    var r = len % 3;
    return r > 0 ? b.slice(0, r) + "," + b.slice(r, len).match(/\d{3}/g).join(",") : b.slice(r, len).match(/\d{3}/g).join(",");
  },

  shortName: function(value, length) {
    if(value && value.length > length){
      return value.substring(0, length - 1) + '...'
    } else {
      return value
    }
  }
}

export default vueFilter
