import App from '../App'

// 等待会话
const waitingSessionList = r => require.ensure([], () => r(require('../views/IM/waiting-session/list.vue')), 'waitingSessionList')

// 消息查询
const searchMessageList = r => require.ensure([], () => r(require('../views/IM/search-message/list.vue')), 'searchMessageList')
const searchMessageDetail = r => require.ensure([], () => r(require('../views/IM/search-message/detail.vue')), 'searchMessageDetail')

// 当前会话
const currentSessionList = r => require.ensure([], () => r(require('../views/IM/current-session/index.vue')), 'currentMessageIndex')
const currentSessionDetail = r => require.ensure([], () => r(require('../views/IM/current-session/detail.vue')), 'currentMessageDetail')

// 我要群发
const chainMessage = r => require.ensure([], () => r(require('../views/IM/chain-message/index.vue')), 'chainMessage')

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/waiting-session-list'
        }, {
            path: '/home',
            component: waitingSessionList
        }, {
            path: '/waiting-session-list',
            component: waitingSessionList
        }, {
            path: '/search-message-list',
            component: searchMessageList
        }, {
            path: '/search-message-detail',
            component: searchMessageDetail
        },  {
            path: '/current-session-list',
            component: currentSessionList
        }, {
            path: '/current-session-detail',
            component: currentSessionDetail
        }, {
            path: '/chain-message',
            component: chainMessage
        }

    ]
}]