// see http://vuejs-templates.github.io/webpack for documentation.
var path = require('path')

module.exports = {
    build: {
        env: {
            NODE_ENV: '"production"'
        },
        index: path.resolve(__dirname, '../yqy/index.html'),
        assetsRoot: path.resolve(__dirname, '../yqy'),
        assetsSubDirectory: './static',
        assetsPublicPath: '/yqy/',
        productionSourceMap: true,
        // Surge or Netlify already gzip all static assets for you.
        // Before setting to `true`, make sure to:
        // npm install --save-dev compression-webpack-plugin
        productionGzip: false,
        productionGzipExtensions: ['js', 'css']
    },
    dev: {
        env: {
            NODE_ENV: '"development"'
        },
        port: 8000,
        assetsSubDirectory: 'static',
        assetsPublicPath: '/',
        
        proxyTable: {
            '/': {
                // target: 'http://localhost:8084',
                // target: 'http://10.64.1.93:8084',
                // target: 'http://10.64.1.179:8084',
                // target: 'http://10.64.1.227:8084',
                // target: 'http://172.31.100.141:8084',
                // target: 'http://192.168.10.58:8084',
                // target: 'http://192.168.80.44:9000',

                target: 'http://test1-sc.yunqueyi.com/',
                // target: 'http://test1-api.yunqueyi.com',
                changeOrigin: true
            }
        },

        context: [ //代理路径
            // '/shopping',
            // '/ugc',
            // '/v1',
            // '/v2',
            // '/v3',
            // '/v4',
            // '/bos',
            // '/member',
            // '/promotion',
            // '/eus',
            // '/payapi',
            // '/img',
            '/exams'
        ],
        proxypath: 'http://test1-sc.yunqueyi.com',
        // proxypath: 'http://test1-api.yunqueyi.com',
        // proxypath: 'http://cangdu.org:8001',
        // CSS Sourcemaps off by default because relative paths are "buggy"
        // with this option, according to the CSS-Loader README
        // (https://github.com/webpack/css-loader#sourcemaps)
        // In our experience, they generally work as expected,
        // just be aware of this issue when enabling this option.
        cssSourceMap: false
    }
}