const vueFilter = {
    liveDateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm:ss");
    },
    continueTimesFilter: (value) => {
        if (!value) return '';
        var duration = value / 1000;
        var s = Math.floor(duration % 60).toString();
        if (s.length < 2) {
            s = '0' + s;
        }
        var m = Math.floor((duration % 3600) / 60).toString();
        if (m.length < 2) {
            m = '0' + m;
        }
        var h = Math.floor(duration / 60 / 60).toString();
        if (h.length < 2) {
            h = '0' + h;
        }
        if (parseInt(h) >= 1) {
            return h + '时' + m + '分' + s + '秒';
        } else {
            return m + '分' + s + '秒';
        }
    },
    liveFilter: (value) => {
        if (value.liveStatus == 1) {
            return '未开始'
        } else if (value.liveStatus == 5) {
            return '直播中'
        } else if (value.liveStatus == 10 && value.lookBackStatus == 2) {
            return '已结束(不可回看)'
        } else if (value.liveStatus == 10 && value.lookBackStatus == 1) {
            return '已结束(可回看)'
        }
    },
    liveStatusFilter: (value) => {
        if (value == 1) return "隐藏"
        else return "发布"
    },
    liveTeacherType: (value) => {
        let doctorName = []
        if (value.length > 3) {
            for (let i = 0; i < 3; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、") + '...'
        } else {
            for (let i = 0; i < value.length; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、")
        }
    },
    controlType: (value) => {
        if (value == 1) {
            return '分页1'
        } else if (value == 2) {
            return '分页2'
        } else if (value == 3) {
            return '图片1'
        } else if (value == 4) {
            return '图片2'
        } else if (value == 6) {
            return '视频'
        }
    },
    tabControlType: (value) => {
        if (value == 3) {
            return '图片1'
        } else if (value == 4) {
            return '图片2'
        } else if (value == 6) {
            return '视频'
        }
    },
    refreshType: (value) => {
        if (value == 1) return "支持"
        else return "不支持"
    },
    moudleType: (value) => {
        if (value == 1) return "未激活"
        else return "激活"
    },
    dateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm");
    },
    appColumnStatusFilter: (value) => {
        if (value == 1) return "未提交"
        else if (value == 4) return "已提交"
    },
    statusFilter: (value) => {
        if (value == 1) return "已创建"
        else if (value == 5) return "已发布"
        else return "已下架"
    },
    linkTypeFilter: (value) => { // 跳转类型
        if (value == 1) return '链接'
        else if (value == 4) return '模块'
        else return '无跳转'
    },
    teacherStatusFilter: (value) => {
        if (value == 1) return "已下架"
        else return "已发布"
    },
    moduleTypeFilter: (value, data) => {  // 模块类型
        for (let key in data) {
            if (value == key) {
                return data[key]
            }
        }
    },
    contentCreatedType: (value, data) => {
        for (let i = 0; i < data.length; i++) {
            if (value == data[i].id) {
                return data[i].name
            }
        }

    },
    contentModifiedType: (value, data) => {
        for (var i = 0; i < data.length; i++) {
            if (value == data[i].id) {
                return data[i].name
            }
        }
    },
    columnPositionType: (value, data) => {  // 位置
        for (let key in data) {
            if (value == key) {
                return data[key]
            }
        }
    },
    // 项目组件
    statusFileter: (value) => {
        if (value == 1) {
            return '草稿'
        } else if (value == 2) {
            return '未启用'
        } else if (value == 3) {
            return '已启用'
        } else {
            return '已禁用'
        }
    },
    //项目管理
    statusProject: (value) => {
        if (value == 1) {
            return '草稿'
        } else if (value == 2) {
            return '未上架'
        } else if (value == 3) {
            return '审批中'
        } else if (value == 4) {
            return '已上架'
        } else if (value == 5) {
            return '已下架'
        } else {
            return '已拒绝'
        }
    },
    projeceRoleType: (value) => {
        if (value == "L1") {
            return '内部管理员'
        } else if (value == "L2") {
            return '项目负责人'
        } else if (value == "L3") {
            return '次级负责人'
        } else if (value == "L4") {
            return '普通用户'
        }
    },
    // 问卷
    questionStatus: (value) => {
        if (value == 1) {
            return '下线'
        } else {
            return '上线'
        }
    },
    modifyType: (value, data) => {
        let userName = ''
        for (let i = 0; i < data.length; i++) {
            if (value == data[i].id) {
                userName = data[i].userName
                break
            } else {
                userName = ''
            }
        }
        return userName
    },

    // 时间处理
    timeFormat: (value) => {
        let cTime = new Date().getTime();
        // var $time = document.getElementById("share-time");
        // var date = $time.innerHTML.trim();
        var tt = new Date(parseInt(value));
        var days = parseInt((cTime - value) / 86400000);
        var today = new Date().getDate();
        var year = tt.getFullYear();
        var mouth = tt.getMonth() + 1;
        var day = tt.getDate();
        var time = tt.getHours() < 10 ? "0" + tt.getHours() : tt.getHours();
        var min = tt.getMinutes() < 10 ? "0" + tt.getMinutes() : tt.getMinutes();
        var result, offset;
        offset = Math.abs(today - day);
        if (days < 4 && offset < 4) {
            if (offset === 0) {
                result = "今天" + time + ":" + min;
            } else if (offset === 1) {
                result = "昨天" + time + ":" + min;
            } else if (offset === 2) {
                result = "前天" + time + ":" + min;
            }
        } else {
            result = year + "-" + mouth + "-" + day + " " + time + ":" + min;
        }
        // $time.innerHTML = result;
        return result;
    },

    // 将字符串截短至指定长度，并用在最后追加特定字符串（例如：...）
    shortName: function (value, length = 10, append = '...') {
        if (value && value.length > length) {
        return value.substring(0, length) + append
        } else {
        return value
        }
    },    
}
export default vueFilter