const vueFilter = {
    priceFilter: value => {
        if(!value) return 0;
        if(value) {
            return (value / 100) + '元'
        }
    },
   statusFilter: (value) => {
    if(value == 1) {
      return '下架'
    }else if(value == 2) {
      return '上架'
    }
   },
   rounding (value) {
      if(value != "" && value != null && value != "null"){
        return value.toFixed(2);
      }
      else if(value == 0){
        return value.toFixed(2);
      }
      else {
        return value;
      }
   },
  priceNum (value) {
    if(value != "" && value != null && value != "null"){
      return (value/100).toFixed(2);
    }
    else if(value == 0){
      return (value/100).toFixed(2);
    }
    else {
      return value;
    }
  },
    diagnosisTypeFilter: (value) => {
        if(value == 1) {
            return '音频'
        }else if(value == 2) {
            return '视频'
        }
    },
    liveDateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm:ss");
    },
    continueTimesFilter: (value, flag) => {
        if (!value) return '';
        var duration = value / 1000;
        var s = Math.floor(duration % 60).toString();
        if (s.length < 2) {
            s = '0' + s;
        }
        var m = Math.floor((duration % 3600) / 60).toString();
        if (m.length < 2) {
            m = '0' + m;
        }
        var h = Math.floor(duration / 60 / 60).toString();
        if (h.length < 2) {
            h = '0' + h;
        }
        if (flag) {
            return h + ':' + m + ':' + s;
        } else {
            if (parseInt(h) >= 1) {
                return h + '时' + m + '分' + s + '秒';
            } else {
                return m + '分' + s + '秒';
            }
        }
    },
    liveTeacherType: (value) => {
        let doctorName = []
        if (value.length > 3) {
            for (let i = 0; i < 3; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、") + '...'
        } else {
            for (let i = 0; i < value.length; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、")
        }
    },
    dateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm");
    },
    moduleTypeFilter: (value, data) => {  // 模块类型
        for (let key in data) {
            if (value == key) {
                return data[key]
            }
        }
    },
    // 时间处理
    timeFormat: (value) => {
        let cTime = new Date().getTime();
        // var $time = document.getElementById("share-time");
        // var date = $time.innerHTML.trim();
        var tt = new Date(parseInt(value));
        var days = parseInt((cTime - value) / 86400000);
        var today = new Date().getDate();
        var year = tt.getFullYear();
        var mouth = tt.getMonth() + 1;
        var day = tt.getDate();
        var time = tt.getHours() < 10 ? "0" + tt.getHours() : tt.getHours();
        var min = tt.getMinutes() < 10 ? "0" + tt.getMinutes() : tt.getMinutes();
        var result, offset;
        offset = Math.abs(today - day);
        if (days < 4 && offset < 4) {
            if (offset === 0) {
                result = "今天" + time + ":" + min;
            } else if (offset === 1) {
                result = "昨天" + time + ":" + min;
            } else if (offset === 2) {
                result = "前天" + time + ":" + min;
            }
        } else {
            result = year + "-" + mouth + "-" + day + " " + time + ":" + min;
        }
        // $time.innerHTML = result;
        return result;
    },

    // 将字符串截短至指定长度，并用在最后追加特定字符串（例如：...）
    shortName: function (value, length = 10, append = '...') {
        if (value && value.length > length) {
            return value.substring(0, length) + append
        } else {
            return value
        }
    },
}
export default vueFilter
