import "@babel/polyfill";

import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
// import store from './store/'
const mixins = require('@/utils/mixins');
import '@/utils/rem'					// 引入自适应
import '@/utils/yqyServerRegister'		// 移动端服务
import FastClick from 'fastclick'
if ('addEventListener' in document) {
    document.addEventListener('DOMContentLoaded', function() {
        FastClick.attach(document.body);
    }, false);
}

import VueLazyload from 'vue-lazyload'
Vue.use(VueLazyload, {
	preLoad: 3,
	// loading: './images/error.png',
	error: require('./images/error.png'),
	attempt: 1
	// lazyComponent: true
})

Vue.use(VueRouter)
Vue.filter('yLocalString', function(value){
	var b = parseInt(value).toString();
	if (b === 'NaN') return 0;
	var len = b.length;
	if (len <= 3) { return b; }
	var r = len % 3;
	return r > 0 ? b.slice(0, r) + "," + b.slice(r, len).match(/\d{3}/g).join(",") : b.slice(r, len).match(/\d{3}/g).join(",");
})
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 加入混合
Vue.mixin({
	...mixins
})
new Vue({
	router,
	// store,
}).$mount('#app')

