class ShareClient {
  constructor(options) {
    this.sdkAppId_ = options.sdkAppId;
    this.userId_ = options.userId;
    this.userSig_ = options.userSig;
    this.roomId_ = options.roomId;
    this.vueInstance = options.vueInstance;;   //vue实例

    this.isJoined_ = false;
    this.isPublished_ = false;
    this.localStream_ = null;

    this.client_ = TRTC.createClient({
      mode: 'live',
      sdkAppId: this.sdkAppId_,
      userId: this.userId_,
      userSig: this.userSig_
    });

    //设置是否默认接收远端流。该方法可在 join() 调用前使用，若在进房后调用，会接收不到后续进房的远端用户音视频流。
    this.client_.setDefaultMuteRemoteStreams(true);
    this.handleEvents();
  }

  async join() {
    // 如果已经加入时报错
    if (this.isJoined_) {
      // alert('共享失败，请稍后重试');
      this.vueInstance.$message({
        message: '共享失败，请稍后重试!',
        type: 'error'
      });
      return;
    }
    try {
      await this.client_.join({
        roomId: this.roomId_
      });
      console.log('共享房间进入成功');
      this.isJoined_ = true;

      // 进入房间就创建共享本地流
      this.localStream_ = TRTC.createStream({
        // disable audio as RtcClient already enable audio
        audio: false,
        // enable screen share
        screen: true,
        userId: this.userId_,
  
      });
      // 设置视频分辨率等参数
      this.localStream_.setScreenProfile({
        width: this.vueInstance.viedoParams.screenProfileWidth,
        height: this.vueInstance.viedoParams.screenProfileHeight,
        frameRate: this.vueInstance.viedoParams.screenProfileFramerate,
        bitrate: this.vueInstance.viedoParams.screenProfileBitrate  /* kbps */
      });

      await this.publish()
      return Promise.resolve(); 
    } catch (e) {
      console.error('ShareClient join room failed! ' + e);
    }
  }

  // 发布本地流
  async publish() {
    if (!this.isJoined_) {
      console.warn('共享屏幕请加入房间');
      return;
    }
    if (this.isPublished_) {
      console.warn('共享屏幕已经发布');
      return;
    }
    try {
      await this.stopPush()
      try {
        await this.localStream_.initialize()
      } catch (error) {
        throw new Error(error)
      }
      
      
      if (!this.vueInstance.canshare) {
        this.vueInstance.$message({
          message: '您当前不是主讲人,无屏幕分享权限！',
          type: 'error'
        });
        this.leave();
        return
      }

      // 监听播放状态  'PLAYING'：开始播放 'PAUSED'：暂停播放
      this.localStream_.on('player-state-changed', event => {
        console.log(`local stream ${event.type} player is ${event.state}`);
      });
       //   //  监听屏幕分享结束
      this.localStream_.on('screen-sharing-stopped', event => {
        console.log('共享结束');
        this.leave();
      });
      this.isPublished_ = true;
      //创建共享屏幕div
      var localVideoWrapEl = document.getElementById('share_video');
      if (!localVideoWrapEl) {
        localVideoWrapEl = document.createElement('div');
        localVideoWrapEl.id = 'share_video';
        document.querySelector("#paint_box").insertBefore(localVideoWrapEl, null);
      }
      if (localVideoWrapEl) {
        // 本地流播放
        await this.localStream_.play(localVideoWrapEl, {
          muted: true,
          objectFit: 'contain'
        });

        await  this.client_.publish(this.localStream_);
        this.showShare()
      }
      
    } catch (e) {
      console.log('用户取消');
      this.leave();
    }
  }

  /**
  * 结束推流
  */
  async stopPush() {
    if (this.localStream_ && this.isPublished_ && this.isJoined_) {
      await this.client_.unpublish(this.localStream_);
      this.isPublished_ = false;
      if (document.getElementById('share_video')) {
        document.getElementById('share_video').remove();
      }
      this.localStream_.close();
    }
  }

  // 退出
  async leave() {
    if (!this.isJoined_) {
      console.warn('leave() - please join() firstly');
      return;
    }
    // 如果是正在发布流，就先停止流
    if (this.isPublished_) {
      await this.client_.unpublish(this.localStream_);
      this.isPublished_ = false;
    }
    await this.client_.leave();

    if (this.localStream_) {
      this.localStream_.close();
      this.localStream_ = null;
    }
    this.isShare = false;
    this.isJoined_ = false;
    this.hideShare()
  }

  handleEvents() {
    this.client_.on('error', err => {
      console.error(err);
      this.leave();
      // alert(err);
    });
    this.client_.on('client-banned', err => {
      this.leave();
      console.error('client has been banned for ' + err);
    });
    // 嘉宾加入房间时触发
    this.client_.on('peer-join', evt => {
      const userId = evt.userId;
      console.log('嘉宾加入房间时触发 ' + userId);
    });
    // 嘉宾离开房间时触发
    this.client_.on('peer-leave', evt => {
      const userId = evt.userId;
      console.log('嘉宾离开房间时触发' + userId);
    });
    // 在添加远程流时触发
    this.client_.on('stream-added', evt => {
      const remoteStream = evt.stream;
      const id = remoteStream.getId();
      const userId = remoteStream.getUserId();
      console.log(`remote stream added: [${userId}] ID: ${id} type: ${remoteStream.getType()}`);
      console.log(' 在添加远程流时触发');
    });
    // 在订阅远程流时触发
    this.client_.on('stream-subscribed', evt => {
      const uid = evt.userId;
      const remoteStream = evt.stream;
      const id = remoteStream.getId();
      remoteStream.on('player-state-changed', event => {
        console.log(`${event.type} player is ${event.state}`);
      });
      console.log('在订阅远程流时触发');
    });
    // 当远程流被移除时触发, e.g. the remote user called Client.unpublish()
    this.client_.on('stream-removed', evt => {
      const remoteStream = evt.stream;
      const id = remoteStream.getId();
      console.log(`stream-removed ID: ${id}  type: ${remoteStream.getType()}`);
      console.log('当远程流被移除时触发');
    });
    // 当远程流被更新时触发
    this.client_.on('stream-updated', evt => {
      const remoteStream = evt.stream;
      console.log('当远程流被更新时触发');
    });

    this.client_.on('mute-audio', evt => {
      console.log(evt.userId + ' mute audio');
    });
    this.client_.on('unmute-audio', evt => {
      console.log(evt.userId + ' unmute audio');
    });
    this.client_.on('mute-video', evt => {
      console.log(evt.userId + ' mute video');
    });
    this.client_.on('unmute-video', evt => {
      console.log(evt.userId + ' unmute video');
    });
  }

  // 显示分享屏幕div
  showShare() {
    if (this.vueInstance) {
      this.vueInstance.isShare = true;
    }
  }

  // 隐藏分享屏幕div
  hideShare() {
    if (this.vueInstance) {
      this.vueInstance.isShare = false;
    }
  }
}
export default ShareClient