/**
 * 常量定义文件
 *
 */

// 预约类型list
export const TYPE_LIST = [
  {
    label: '全部',
    value: '',
  },
  {
    label: '语音问诊',
    value: 1,
  },
  {
    label: '视频问诊',
    value: 2,
  },
  {
    label: '图文问诊',
    value: 3,
  },
];

// 支付方式
export const PAY_LIST = [
  {
    label: '代付',
    value: 1,
  },
  {
    label: '扫码支付',
    value: 2,
  },
  {
    label: '分享支付',
    value: 3,
  },
];

// 订单来源
export const SOURCE_LIST = [
  {
    label: '全部',
    value: '',
  },
  {
    label: '铁军反馈',
    value: 1,
  },
  {
    label: '主动联系',
    value: 2,
  },
  {
    label: '问卷收集',
    value: 3,
  },
  {
    label: '微信群反馈',
    value: 4,
  },
  {
    label: '话题讨论与回复',
    value: 5,
  },
];
// 订单价格
export const ORDER_PRICE = [
  {
    label: '全部',
    value: null,
  },
  {
    label: '0元订单',
    value: 0,
  },
  {
    label: '付费订单',
    value: 9999,
  },
];
// 匹配方式
export const MATCHING_LIST = [
  {
    label: '自动匹配',
    value: 1,
  },
  {
    label: '人工匹配',
    value: 2,
  },
];
// 订单状态
export const STATUS_LIST = [
  {
    label: '初始状态（未支付）',
    value: 1,
  },
  {
    label: '待问诊（支付成功待完善)',
    value: 2,
  },
  {
    label: '问诊中（已完善)',
    value: 3,
  },
  {
    label: '已问诊',
    value: 4,
  },
  {
    label: '已取消',
    value: 5,
  },
  {
    label: '已结算',
    value: 6,
  },
  {
    label: '已匹配',
    value: 21,
  },
  {
    label: '待分诊',
    value: 22,
  },
  {
    label: '待匹配医生',
    value: 23,
  },
  {
    label: '待协调医生',
    value: 24,
  },
  {
    label: '待确认时间',
    value: 25,
  },
  {
    label: '待问诊',
    value: 26,
  },
];

// 证件类型
export const CAR_LIST = [
  {
    label: '居民身份证',
    value: 1,
  },
  // {
  //   label: '护照',
  //   value: 2
  // },
  // {
  //   label: '港澳通行证',
  //   value: 3
  // }
];

// 性别
export const SEX_LIST = [
  {
    label: '男',
    value: 1,
  },
  {
    label: '女',
    value: 2,
  },
];

// 与患者关系
export const RELATION_LIST = [
  {
    label: '自己',
    value: 1,
  },
  {
    label: '患者',
    value: 2,
  },
  {
    label: '家属',
    value: 3,
  },
  {
    label: '朋友',
    value: 4,
  },
];

// 医生来源
export const D_S_LIST = [
  {
    label: '全部',
    value: '',
  },
  {
    label: '京东',
    value: 1,
  },
  {
    label: '同事推荐',
    value: 2,
  },
  {
    label: '云鹊医平台',
    value: 3,
  },
];

// 是否跟进
export const IS_FLLOW = [
  {
    label: '全部',
    value: '',
  },
  {
    label: '是',
    value: 1,
  },
  {
    label: '否',
    value: 2,
  },
];

// 创建订单方式
export const CREATE_TYPE = [
  {
    label: '全部',
    value: '',
  },
  {
    label: '系统创建',
    value: 1,
  },
  {
    label: '手动创建',
    value: 2,
  },
];

// 是否匹配
export const OPERATE_LIST = [
  {
    label: '全部',
    value: '',
  },
  {
    label: '已分配',
    value: 1,
  },
  {
    label: '未分配',
    value: 2,
  },
];

// 跟进状态
export const FOLLW_LIST = [
  {
    label: '待跟进',
    value: 1,
  },
  {
    label: '跟进中（协调资源）',
    value: 2,
  },
  {
    label: '已完成（跟进结束）',
    value: 3,
  },
  {
    label: '长期跟进',
    value: 4,
  },
];

// 0 只填写了患者信息（急速问诊才会有的状态），1 初始状态（未支付），2待问诊（支付成功待完善）3 问诊中（已完善），4、已问诊  5、取消，  6 已结算
// 21 已匹配 22 待分诊 23 待匹配接诊医生 24 待协调医生 25 待设置问诊时间 26 待问诊
// 预约单列表
export const ALL_TAB_LIST = [
  {
    label: '全部',
    active: '99',
  },
  {
    label: '待匹配',
    active: '2',
  },
  {
    label: '已匹配',
    active: '102',
  },
  {
    label: '稍后跟进',
    active: '101',
  },
  {
    label: '待分诊',
    active: '22',
  },
  {
    label: '待匹配医生',
    active: '23',
  },
  {
    label: '待协调医生',
    active: '24',
  },
  {
    label: '待确认时间',
    active: '25',
  },
  {
    label: '待问诊',
    active: '26',
  },
  {
    label: '问诊中',
    active: '3',
  },
  {
    label: '已完成',
    active: '4',
  },
  {
    label: '已结算',
    active: '6',
  },
  {
    label: '已取消',
    active: '5',
  },
];

// 运营预约单列表
export const RUN_TAB_LIST = [
  {
    label: '全部',
    active: '99',
  },
  // {
  //   label: '待匹配',
  //   active: '2'
  // },
  // {
  //   label: '已匹配',
  //   active: '21'
  // },
  // {
  //   label: '待确认时间',
  //   active: '25'
  // },
  {
    label: '待问诊',
    active: '26',
  },
  {
    label: '问诊中',
    active: '3',
  },
  {
    label: '已完成',
    active: '4',
  },
  {
    label: '已结算',
    active: '6',
  },
  {
    label: '已取消',
    active: '5',
  },
];

// 分诊列表
export const TRIAGE_TAB_LIST = [
  {
    label: '全部',
    active: '99',
  },
  // {
  //   label: '待分诊',
  //   active: '22'
  // },
  {
    label: '待匹配',
    active: '2',
  },
];

// 接诊列表
export const RECEPTION_TAB_LIST = [
  {
    label: '全部',
    active: '99',
  },
  {
    label: '待匹配医生',
    active: '23',
  },
  {
    label: '待协调医生',
    active: '24',
  },
  {
    label: '待确认时间',
    active: '25',
  },
];

// 外呼列表
export const MATCH_TAB_LIST = [
  {
    label: '全部',
    active: '99',
  },
  {
    label: '已匹配',
    active: '102',
  },
  {
    label: '稍后跟进',
    active: '101',
  },
];
export const TABLE_COLUMN = [
  {
    prop: 'diagnoseLogId',
    label: 'ID',
    showtooltip: false,
  },
  {
    prop: 'orderNo',
    label: '订单ID',
    showtooltip: false,
  },
  {
    prop: 'diagnoseTypeStr',
    label: '预约类型',
    showtooltip: false,
  },
  {
    prop: 'statusStr',
    label: '状态',
    showtooltip: false,
  },
  {
    prop: 'statusRemark',
    label: '状态备注',
    showtooltip: false,
  },

  {
    prop: 'toFollowReason',
    label: '稍后跟进备注',
    showtooltip: false,
  },

  {
    prop: 'appointBeginTime',
    label: '预约时间',
    showtooltip: false,
  },
  {
    prop: 'operateUserId',
    label: '运营人员ID',
    showtooltip: false,
  },
  {
    prop: 'operateUserName',
    label: '运营人员',
    showtooltip: false,
  },
  {
    prop: 'userName',
    label: '助诊医生',
    showtooltip: false,
  },
  {
    prop: 'userMobile',
    label: '助诊电话',
    showtooltip: false,
  },
  {
    prop: 'assistantBeginTime',
    label: '助诊医生意向时间',
    showtooltip: false,
  },

  {
    prop: 'assistantRemark',
    label: '助诊备注',
    showtooltip: true,
  },
  {
    prop: 'department',
    label: '预约科室',
    showtooltip: false,
  },
  {
    prop: 'triageDepartment',
    label: '分诊科室',
    showtooltip: false,
  },
  {
    prop: 'triageRemark',
    label: '分诊备注',
    showtooltip: true,
  },
  {
    prop: 'doctorName',
    label: '接诊医生',
    showtooltip: false,
  },
  {
    prop: 'doctorMobile',
    label: '接诊电话',
    showtooltip: false,
  },
  {
    prop: 'outsideDoctor',
    label: '站外医生姓名',
    showtooltip: false,
  },
  {
    prop: 'receptionBeginTime',
    label: '接诊医生意向时间',
    showtooltip: false,
  },
  {
    prop: 'patientName',
    label: '患者姓名',
    showtooltip: false,
  },

  {
    prop: 'age',
    label: '患者年龄',
    showtooltip: false,
  },

  {
    prop: 'patientMobilePhone',
    label: '患者电话',
    showtooltip: false,
  },
  {
    prop: 'illnessDetail',
    label: '病情描述',
    showtooltip: true,
  },
  {
    prop: 'idCard',
    label: '证件号',
    showtooltip: false,
  },
  {
    prop: 'sexStr',
    label: '性别',
    showtooltip: false,
  },
  {
    prop: 'diagnoseStageStr',
    label: '初/复诊',
    showtooltip: false,
  },
  {
    prop: 'determineFlagStr',
    label: '是否确诊',
    showtooltip: false,
  },
  {
    prop: 'diagnoseDisease',
    label: '确诊疾病',
    showtooltip: true,
  },
  {
    prop: 'triageOperatorName',
    label: '分诊运营',
    showtooltip: false,
  },
  {
    prop: 'receptionOperatorName',
    label: '接诊运营',
    showtooltip: false,
  },
  {
    prop: 'diagnoseAdvice',
    label: '诊断建议',
    showtooltip: true,
  },
  {
    prop: 'crrsName',
    label: '招募人',
    showtooltip: false,
  },
  {
    prop: 'diagnoseChannelStr',
    label: '问诊方式',
    showtooltip: false,
  },
  {
    prop: 'doneTime',
    label: '完成时间',
    showtooltip: false,
  },

  {
    prop: 'cancelTime',
    label: '退款时间',
    showtooltip: false,
  },
  {
    prop: 'createdTime',
    label: '创建时间',
    showtooltip: false,
  },
  {
    prop: 'followFlagStr',
    label: '是否跟进',
    showtooltip: false,
  },

  {
    prop: 'drugFollowStatusStr',
    label: '药品跟进状态',
    showtooltip: false,
  },
  {
    prop: 'drugFollow',
    label: '药品跟进',
    showtooltip: false,
  },
  {
    prop: 'checkFollowStatusStr',
    label: '检查跟进状态',
    showtooltip: false,
  },
  {
    prop: 'checkFollow',
    label: '检查跟进',
    showtooltip: false,
  },
  {
    prop: 'otherFollowStatusStr',
    label: '其他跟进事项状态',
    showtooltip: false,
  },
  {
    prop: 'otherFollow',
    label: '其他跟进事项',
    showtooltip: false,
  },
  {
    prop: 'remark',
    label: '跟进备注',
    showtooltip: true,
  },
];
