import axios from 'axios';
// import { getHostnameAndPort } from '../utils'
// axios.defaults.withCredentials = true

// 创建axios实例对象
const service = axios.create({
  // baseURL: process.env.BASE_API
  timeout: 600000,
  withCredentials: false,
});

// request拦截器
service.interceptors.request.use(
  (config) => {
    config.headers['sysCode'] = 26;
    config.headers['token'] = localStorage.getItem('token');
    config.headers['deviceInfo'] = JSON.stringify({
      app_channel: '',
      app_mac: '',
      app_uuid: '',
      app_version: '',
      device_brand: '',
      device_ip: '',
      device_model: '',
      device_net: '',
      device_ops: '',
      resolution_wh: '',
      system_level: '',
      device_type: '10',
    });
    Object.assign(config.headers, config.changeHeader);
    if (config.fileHeader) {
      config.headers['Content-Type'] = 'application/x-www-form-urlencoded';
    }
    return config;
  },
  (error) => {
    Promise.reject(error);
  }
);

// respone拦截器
service.interceptors.response.use(
  (response) => {
    return response.data;
  },
  (error) => {
    return Promise.reject(error);
  }
);
export default service;
