import App from '../App'

// 等待会话
const waitingSessionList = r => require.ensure([], () => r(require('../views/IM/waiting-session/list.vue')), 'waitingSessionList')

const searchMessageList = r => require.ensure([], () => r(require('../views/IM/search-message/list.vue')), 'searchMessageList')
const searchMessageDetail = r => require.ensure([], () => r(require('../views/IM/search-message/detail.vue')), 'searchMessageDetail')

// 当前会话
const currentSessionIndex = r => require.ensure([], () => r(require('../views/IM/current-session/index.vue')), 'currentMessageIndex')
const currentSessionDetail = r => require.ensure([], () => r(require('../views/IM/current-session/detail.vue')), 'currentMessageDetail')

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/waiting-session-list'
        }, {
            path: '/home',
            component: waitingSessionList
        }, {
            path: '/waiting-session-list',
            component: waitingSessionList
        }, {
            path: '/search-message-list',
            component: searchMessageList
        }, {
            path: '/search-message-detail',
            component: searchMessageDetail
        },  {
            path: '/current-session-index',
            component: currentSessionIndex
        }, {
            path: '/current-session-detail',
            component: currentSessionDetail
        }

    ]
}]