// import { searchContent } from '@/api/diagnosis';

module.exports = {
    data: function() {
        return {
            token: null
        };
    },
    created: function() {
        //  let query = this.$router.query
        // this.token = this.getUrlSearch(location.href, 'token') || (query && query.token) || null
        //  this.token = this.getUrlKey('token') || (query && query.token) || null
    },
    mounted: function() {

    },
    methods: {
        getUrlPara(obj) {
            let dataStr = '';
            const list = [];
            for (const attr in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, attr) && attr != 'data') {
                    list.push(attr + '=' + obj[attr]);
                }
            }
            dataStr = list.join('&');
            if (dataStr !== '') {
                return '?' + dataStr;
            }
            return '';
        },

        setRouterParm(paramList) {
            const parm = {};
            if (paramList.length <= 1) {
                return '';
            }
            for (let i = 1; i < paramList.length; i++) {
                parm[paramList[i].key] = paramList[i].value;
            }
            return parm;
        },

        // 拼接多个参数
        getUrlParmByCode(paramList) {
            if (paramList.length <= 1) {
                return '';
            }
            let dataStr = '';
            const list = [];
            for (let i = 1; i < paramList.length; i++) {
                list.push(paramList[i].key + '=' + paramList[i].value);
            }
            dataStr = list.join('&');
            if (dataStr !== '') {
                return '?' + dataStr;
            }
            return '';
        },
        // 处理五分钟数据 初始化播放状态
        handelFive(d) {
            for (let i = 0; i < d.length; i++) {
                d[i].play = '0';
            }
            return d;
        },

        // 根据条件排序
        // async searchForOrder(searchCategory = '1', searchValue = '', sortItem = 1, pageSize = 10, sourceData = []) {
        //     if (pageSize <= 0) return;
        //     const str2 = (searchValue || '').replace(/[\-\_\,\!\|\~\`\(\)\#\$\%\^\&\*\{\}\:\;\"\L\<\>\?]/g, ''); // 去掉特殊字符
        //     const _this = this,
        //         para = {
        //             searchCategory: searchCategory,
        //             searchValue: str2,
        //             keywordColor: 'rgba(244,122,72,1)',
        //             sortItem: sortItem,
        //             pageNo: 1,
        //             pageSize: pageSize,
        //             token: _this.token,
        //             setEntry: 'headers',
        //         };

        //     const csourceData = await searchContent(para).then(res => {
        //         // _this.searchText = ''
        //         if (res.code == '000000') {
        //             // 课程
        //             if (searchCategory.indexOf('1') >= 0) {
        //                 sourceData = (res.data && res.data.contentAppModels) || [];
        //             }
        //             if (searchCategory.indexOf('2') >= 0) {
        //                 // sourceData = []
        //                 sourceData = this.handelFive(res.data.fiveMinutesMedicalContentList || []);
        //             }
        //             if (searchCategory.indexOf('3') >= 0) {
        //                 sourceData = (res.data && res.data.pCourseDoctorModels) || [];
        //             }
        //             if (searchCategory.indexOf('4') >= 0) {
        //                 sourceData = res.data.educationContents;
        //             }
        //         }
        //         return sourceData || [];
        //     });
        //     return csourceData;
        // },

        setEventByModuleCode(itemData) {
            const modeCode = itemData.appModuleInfo.code || '';
            let paramList = itemData.appModuleInfo.paramList ? itemData.appModuleInfo.paramList : '';

            if (modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
                paramList = '';
            } else if (modeCode === 'M100' || modeCode === 'M300') {
                // 支持多个参数
                const urlPara = this.getUrlParmByCode(paramList);
                if (paramList[0]) {
                    if (paramList[0].value.indexOf('?') == -1) {
                        paramList[0].value += urlPara;
                    }
                }
            } else if (modeCode === 'M400') {
                // const path = paramList[0]['key'];
                const v = paramList[0]['value'];
                const query = this.setRouterParm(paramList);
                paramList = [{
                    url: v,
                    query: query
                }];
                this.$router.push({
                    path: v,
                    query: query
                });
                // alert(this.token);
                return 'NO';
            }
            if (typeof paramList === 'string' && !paramList) {
                paramList = [];
            }
            return paramList;
        },
        // 从html参数
        getUrlKey(name) {
            if (decodeURIComponent && location.href) {
                return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.href) || [''])[1].replace(/\+/g, '%20')) || null;
            } else {
                return null;
            }
        },
        getUrlSearch(url, name) {
            if (typeof name == 'undefined') {
                name = url;
                url = location.href;
            }
            var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
            var r = url.slice(url.indexOf('?') + 1).match(reg);
            if (r != null) {
                try {
                    return decodeURIComponent(r[2]);
                } catch (_e) {
                    return null;
                }
            }
            return null;
        },

        // 图片处理-新
        imgSizeHandleNew(item, imgWidth, imgHeight) {
            let lw, lh, newW, newH;
            const imgProportion = (imgWidth / imgHeight).toFixed(1);
            if (imgProportion > 0.6) {
                if (imgWidth > 192) {
                    lw = 192;
                    lh = (imgHeight * lw) / imgWidth;
                } else if (imgWidth <= 192) {
                    lw = imgWidth;
                    lh = imgHeight;
                }
            } else if (imgProportion == 0.6) {
                if (imgHeight > 320) {
                    lh = 320;
                } else {
                    lh = imgHeight;
                }
                lw = lh * 0.6;
            } else {
                if (imgHeight > 320) {
                    lh = 320;
                    lw = (imgWidth * lh) / imgHeight;
                } else if (imgHeight <= 320) {
                    lh = imgHeight;
                    lw = imgWidth;
                }
            }
            if (lh < 32 && lh < lw) {
                newH = 32;
                newW = (lw * 32) / lh;
            } else if (lw < 32 && lw < lh) {
                newW = 32;
                newH = (lh * 32) / lw;
            } else {
                newH = lh;
                newW = lw;
            }
            item.newW = newW;
            item.newH = newH;
        },

    }
};
