// import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import vueFilters from '@/utils/filter';
import WebBuriedPoint, { sendBuriedData } from '@pica-core/web-buried-point';
import { getBaseUrl } from '@/utils/index'

// 引入ElementUI
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css';
import vViewer from 'v-viewer';
import 'viewerjs/dist/viewer.css';
import ClipboardJS from 'clipboard';
import '@/utils/directive';
import TRTC from 'trtc-js-sdk';
import TIM from 'tim-js-sdk';

Vue.prototype.ClipboardJS = ClipboardJS;
Vue.use(vViewer, {
	button: false
});

// 可调试
// Vue.config.devtools = true;

Vue.use(ElementUI)

// 注册所有公用过滤器
for(let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}


Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})
//vue 全局引入埋点
Vue.prototype.$sendBuriedData = sendBuriedData;
const b = getBaseUrl('');
Vue.use(WebBuriedPoint, {
  class_name: "pica-admin-consultation",
  url: `${b}/file/log/trace1`, // 埋点上报接口 根据环境区分
});


Vue.use(TRTC)
window.TRTC = TRTC
Vue.use(TIM)
window.TIM = TIM

// 加入混合
Vue.mixin({
	...mixins
})
new Vue({
	router,
	store,
}).$mount('#app');

