import WebIMObj from '@/utils/live/WebIM.js'
module.exports = {
  data() {
    return {
    }
  },
  created() {
  },
  methods: {
    // 初始化Im
    initIM() {
      this.WebIM = new WebIMObj({roomId: this.roomId})
      this.WebIM.init(this.sdkAppId)
      this.WebIM.tim.on(TIM.EVENT.SDK_READY, this.onTimSdkReady)
      this.WebIM.tim.on(TIM.EVENT.SDK_NOT_READY, this.onTimSdkNotReady)
      this.IMlogin()
    },
    // TIM SDK 准备完成        注意：这时需要将vue实例传入
    onTimSdkReady() {
      this.IMJion();
      console.log('TIM SDK 准备完成')
      // this.createRoom();
      // 将vue实例传入，方便消息回调
      this.WebIM.addEvent(this)
    },
    // SDK 准备失败
    onTimSdkNotReady(event) {
      console.log('TIM SDK 准备失败 => ', event)
    },
    // Im登录
    IMlogin() {
      this.WebIM.login({
        userId: this.userId,
        userSig: this.userSig
      }).then(() => {
        // this.IMJion();
      }, error => {
        console.log('抱歉登录失败')
      })
    },
    // WebIM创建聊天房间
    createRoom() {
      this.WebIM.createRoom(this.roomId).then(() => {
        // 创建课堂-end
        console.log('创建room成功')
        this.IMJion()
      }, error => {
        console.log('创建room失败')
        this.IMJion()
      })
    },
    // WebIM加入房间
    IMJion() {
      this.WebIM.joinRoom(this.roomId).then(res => {
        this.addFriends(this.nickShow)
        this.joined = true
        this.WebIM.updateMyProfile({
          nick: this.nick,
          avatar: this.faceUrl
        }).then(() => {
          console.log('im 个人信息更新成功');
        }).catch((errr) => {
          console.log('更新资料失败', err)
        })
      }).catch((err) => {
        console.log('加入房间失败', err)
      })
    },
    // 退出
    leaveIm() {
      vm.WebIM.quitGroup(vm.roomId)
    },
    //所有消息
    onRecvMessage(msg) {
    },
    // 被踢出房间
    onClassroomDestroy() {
    },
    // WebIm退出
    quitClassroom() {
      vm.WebIM.quitGroup().then(() => {
      }).catch((error) => {
      })
    },
    //销毁WebIm
    destroyClassroom(classId, callback) {
      vm.WebIM.destroyGroup(classId).then(data => {
        // vm.ticWebRTC && vm.ticWebRTC.quit()
      }).catch(error => {
      })
    },
  }
}