// ES6 import
import io from 'socket.io-client';

export default {
  namespaced: true,
  state: {
    socketClient: null
  },
  actions: {
    initSocket ({ commit, rootState }, payload) {
      const socket = io.connect(payload.url, {
        query: {
          // loginUserNum: `diagnose_list_socket_${userId}`
          loginUserNum: `diagnose_list_socket_888`
        }
      });
      console.log('-=-=-=-=',socket)
      commit('SET_SOCKET', socket);
      commit('SET_IOLISTION');
    },
  },
  mutations: {
    SET_SOCKET: (state, payload) => {
      window.socketClient = payload;
      state.socketClient = payload;

    },
    SET_IOLISTION: (state, payload) => {
      if(!state.socketClient){
        return false;
      }
      state.socketClient.on("connection", (socket) => {
        console.log ('socket 链接成功',socket);
      });
      state.socketClient.on("connect_error", (err) => {
        console.log ('socket connect_error',err);
      });
      state.socketClient.on("disconnect", (socket) => {
        console.log ('socket disconnect',socket);
      });
      state.socketClient.on("diagnose_push_event", (socket) => {
        console.log('diagnose_push_event---', socket);
      });
      state.socketClient.on('ping', function () {
        console.log('[E] 心跳请求已发出 →', true);
      });
      //收到
      state.socketClient.on('pong', function () {
        console.log('[E] 心跳响应已收到 ←', true);
      });
    },
  },
};
