/* eslint-disable */
/* 浏览器兼容提示 */
export const CHECK_BROWSER_TIPS = {
  BROWSER_NOT_COMPATIBLE: '您的浏览器不支持直播功能！',
  BROWSER_NOT_SUPPORT_SCREEN_SHARE: '您的浏览器不支持直播功能!',
};

export const setLgTenText = (time) => {
  return time < 10 ? `0${time}` : time;
};

export const getLiveTimeText = (lt, name) => {
  const hr = parseInt(lt / 1000 / 60 / 60); // 時
  const min = parseInt((lt - hr * 1000 * 60 * 60) / 1000 / 60); // 分 ex: 90秒
  const sec = parseInt((lt - min * 1000 * 60 - hr * 1000 * 60 * 60) / 1000); // 秒

  sessionStorage.setItem(`TIME_${name}`, lt);
  return `${setLgTenText(hr)}:${setLgTenText(min)}:${setLgTenText(sec)}`;
};

export const countDown = (endtime) => {
  const nowtime = new Date(); // 获取当前时间
  const time = endtime - nowtime.getTime(); // 距离结束时间的毫秒数
  if (time > 0) {
    const lefth = Math.floor((time / (1000 * 60 * 60)) % 24); // 计算小时数
    const leftm = Math.floor((time / (1000 * 60)) % 60); // 计算分钟数
    const lefts = Math.floor((time / 1000) % 60); // 计算秒数
    // 返回倒计时的字符串
    return `${setLgTenText(lefth)}:${setLgTenText(leftm)}:${setLgTenText(
      lefts
    )}`;
  } else {
    return '时间已到';
  }
};

export const laseTime = (endtime) => {
  const nowtime = new Date(); // 获取当前时间
  const time = endtime - nowtime.getTime(); // 距离结束时间的毫秒数
  const lefth = Math.floor((time / (1000 * 60 * 60)) % 24); // 计算小时数
  const leftm = Math.floor((time / (1000 * 60)) % 60); // 计算分钟数
  const lefts = Math.floor((time / 1000) % 60); // 计算秒数
  return {
    lefth,
    leftm,
    lefts,
  };
};

export const lastm = (startTime, endTime) => {
  const time = endTime - startTime; // 距离结束时间的毫秒数
  const lefth = Math.floor((time / (1000 * 60 * 60)) % 24); // 计算小时数
  const leftm = Math.floor((time / (1000 * 60)) % 60); // 计算分钟数
  return lefth * 60 + leftm;
};

function listCompare(property, way) {
  return function (obj1, obj2) {
    var value1 = obj1[property];
    var value2 = obj2[property];
    return way ? value1 - value2 : value2 - value1; // 升序
  };
}

// 参数为条件(如先排角色，后是通话中)
export const listSort = (one, two, three, four, arr) => {
  let newList = []; // 新的列表
  const callArr = []; // 正在通话的列表
  const inviteArr = []; // 邀请中的列表
  arr = JSON.parse(JSON.stringify(arr));
  const h = arr.sort(listCompare(four));
  const a = h.sort(listCompare(three));
  const b = a.sort(listCompare(two));
  newList = b.sort(listCompare(one, 1));
  newList.forEach((item) => {
    if (item.isCalling) {
      callArr.push(item);
    }
    if (item.inviteCall) {
      inviteArr.push(item);
    }
  });
  return {
    newList,
    callArr,
    inviteArr,
  };
};

export const isWeixin = () => {
  const ua = navigator.userAgent.toLowerCase();
  return ua.indexOf('micromessenger') != -1;
};

export const getBroswer = () => {
  const sys = {};
  const ua = navigator.userAgent.toLowerCase();
  let s;
  (s = ua.match(/edge\/([\d.]+)/))
    ? (sys.edge = s[1])
    : (s = ua.match(/rv:([\d.]+)\) like gecko/))
    ? (sys.ie = s[1])
    : (s = ua.match(/msie ([\d.]+)/))
    ? (sys.ie = s[1])
    : (s = ua.match(/firefox\/([\d.]+)/))
    ? (sys.firefox = s[1])
    : (s = ua.match(/chrome\/([\d.]+)/))
    ? (sys.chrome = s[1])
    : (s = ua.match(/opera.([\d.]+)/))
    ? (sys.opera = s[1])
    : (s = ua.match(/version\/([\d.]+).*safari/))
    ? (sys.safari = s[1])
    : 0;

  if (sys.edge) return { broswer: 'Edge', version: sys.edge };
  if (sys.ie) return { broswer: 'IE', version: sys.ie };
  if (sys.firefox) return { broswer: 'Firefox', version: sys.firefox };
  if (sys.chrome) return { broswer: 'Chrome', version: sys.chrome };
  if (sys.opera) return { broswer: 'Opera', version: sys.opera };
  if (sys.safari) return { broswer: 'Safari', version: sys.safari };

  return { broswer: '', version: '0' };
};
