import { opAck } from '@/api/diagnosis';
import storejs from 'storejs';
const main = {
  namespaced: true,
  state: {
    currentDiagList: [],
    allSize: 0,
    currentCalList: {},
    RawCurrentCalList: [],
    currentChat: {
      diagnoseType: 1,
      diagnoseLogId: '',
      department: '',
    },
    currentAdvice: {},
    soketQuest: {},
    noticeList: [],
    showChat: false,
    showAdvice: false,
    isSuperAdmin: {
      isSuper: false,
      userID: '',
    },
  },
  mutations: {
    updateCurrentDiagList(state, obj) {
      state.currentDiagList = obj;
    },
    updateAllSize(state, allSize) {
      state.allSize = allSize;
    },
    // 改变原数据
    changeRawCurrentCalList(state, obj) {
      // console.log("obj",obj)

      const index = state.RawCurrentCalList.findIndex((val) => {
        return val.status == obj.status;
      });
      if (index > -1) {
        state.RawCurrentCalList[index] = obj;
        state.currentCalList[index].is_dot = false;
      }
    },
    clearRawCurrentCalList(state) {
      state.RawCurrentCalList = [];
    },
    updateCurrentCalList(state, obj) {
      console.log('obj-------111111111111111-------', obj);
      const NewData = obj;
      if (state.RawCurrentCalList.length == 0) {
        state.RawCurrentCalList = obj;
      }
      const RawData = state.RawCurrentCalList;
      for (let i = 0; i < NewData.length; i++) {
        let is_dot = false;
        if (RawData.length > 0) {
          is_dot = NewData[i].count > RawData[i].count ? true : false;
        }
        NewData[i] = {
          ...NewData[i],
          is_dot: is_dot,
        };
      }
      state.currentCalList = NewData;
    },
    updateCurrentChat(state, obj) {
      state.currentChat = obj;
    },
    updateCurrentAdvice(state, obj) {
      state.currentAdvice = obj;
    },
    updateSoketQuest(state, obj) {
      storejs.set('soketQuest', obj);
      state.soketQuest = obj;
    },
    updateShowChat(state, obj) {
      state.showChat = obj;
    },
    updateShowAdvice(state, obj) {
      state.showAdvice = obj;
    },
    updateNoticeList(state, obj) {
      console.log(11111);
      state.noticeList = obj;
    },
    updateIsSuperAdmin(state, obj) {
      console.log('obj----11111-----', obj);
      state.isSuperAdmin = obj;
    },
  },
  actions: {
    gotoInquiry({ commit }, current) {
      if (current.imTeamId) {
        const params = {
          teamIdList: [current.imTeamId],
        };
        opAck(params)
          .then((res) => {
            if (res.code == '000000') {
              commit('updateShowChat', true);
              commit('updateCurrentChat', current);
            }
          })
          .catch((err) => {
            this.$message({
              message: err.message,
              type: 'warning',
              duration: 1000,
            });
          });
      }
    },
  },
};
export default main;
