import { teamDetail, callDirect } from '@/api/diagnosis';
import { waitPersonNum, manualCall } from '@/api/workbench.js';
import { createNamespacedHelpers } from 'vuex';
const { mapState } = createNamespacedHelpers('main');
let clipboard = null;
export default {
  props: {
    item: {
      type: Object,
      default: () => {
        return {};
      },
    },
    orderType: {
      // 订单类型
      type: String,
      default: '',
    },
    key: {
      // 订单类型
      type: String,
      default: '',
    },
  },
  data() {
    return {
      callImg: require('@/assets/image/workbench/call.png'),
      infocallImg: require('@/assets/image/workbench/calling.png'),
      callouting: require('@/assets/image/workbench/remindalready.png'),
      offline: require('@/assets/image/workbench/offline.png'),
      manuacall: require('@/assets/image/workbench/maulcall.png'),
      manuacallIng: require('@/assets/image/workbench/calling.gif'),
      timer: null,
      isChat: false,
      isUserChat: false,
      isDoctorChat: false,
      isCall: false,
      isManuacall: false,
      isManuacallType: false,
      accId: '',
      waitPersonList: [],
      isShowWait: false,
    };
  },
  computed: {
    ...mapState({
      showChat: (state) => state.showChat,
    }),
    doctorCallStatus() {
      switch (this.item.doctorCallStatus) {
        case 1:
          return '未拨打';
        case 2:
          return '已拨打未接听';
        case 3:
          return '被挂断';
        case 4:
          return '已拨打完成';
        case 5:
          return '电话呼叫中';
        default:
          return '';
      }
    },
    userCallStatus() {
      switch (this.item.userCallStatus) {
        case 1:
          return '未拨打';
        case 2:
          return '已拨打未接听';
        case 3:
          return '被挂断';
        case 4:
          return '已拨打完成';
        default:
          return '';
      }
    },
    appointBeginTime() {
      if (this.item.appointBeginTime) {
        return new Date(this.item.appointBeginTime).format('hh:mm');
      } else {
        return '';
      }
    },
    appointEndTime() {
      if (this.item.appointEndTime) {
        return new Date(this.item.appointEndTime).format('hh:mm');
      } else {
        return '';
      }
    },
    // 基层医生上次呼叫医助时间
    userLastCallTime() {
      if (this.item.userLastCallTime) {
        return new Date(this.item.userLastCallTime).getTime();
      } else {
        return null;
      }
    },
    // 上级医生上一次呼叫医助时间
    doctorLastCallTime() {
      if (this.item.doctorLastCallTime) {
        return this.formatDateData(this.item.doctorLastCallTime);
      } else {
        return null;
      }
    },
    doctorCallTime() {
      return new Date(this.item.doctorCallTime).format('hh:mm');
    },
    pastDoctorCallTime() {
      if (this.item.doctorCallTime) {
        return this.formatDateData(this.item.doctorCallTime);
      } else {
        return null;
      }
    },
    nowtime() {
      return new Date().getTime() - this.item.appointBeginTime;
    },
  },
  watch: {
    item(newVal, oldVal) {
      console.log(newVal, 'newValnewValnewVal');
      console.log(newVal, oldVal, 'newVal, oldVal');
      if (newVal !== oldVal) {
        if (newVal.doctorCallStatus !== oldVal.doctorCallStatus) {
          this.isManuacall = false;
        }
        if (newVal.userCallStatus !== oldVal.userCallStatus) {
          this.isManuacallType = false;
        }
      }
    },
    key(newVal, oldVal) {
      console.log(newVal, oldVal);
    },
  },
  created() {},
  mounted() {},
  methods: {
    manualDialing(type) {
      if (this.doctorCallKfStatus === 1) {
        return;
      }
      this.$confirm('确认要电话通知该医生吗？', '提示', {
        confirmButtonText: '电话通知',
        cancelButtonText: '取消',
        type: 'warning',
      })
        .then(() => {
          let userMobilePhone = '';
          let userId = '';
          let doctorId = '';
          let doctorMobilePhone = '';
          if (type === 1) {
            userMobilePhone = null;
            userId = null;
            doctorId = this.item.doctorId;
            doctorMobilePhone = this.item.doctorMobile;
          } else {
            userMobilePhone = this.item.userMobile;
            userId = this.item.userId;
            doctorId = null;
            doctorMobilePhone = null;
          }
          const params = {
            diagnoseId: this.item.diagnoseLogId,
            doctorId: doctorId,
            doctorMobilePhone: doctorMobilePhone,
            userId: userId,
            userMobilePhone: userMobilePhone,
          };
          manualCall(params).then((res) => {
            if (res.code === '000000') {
              if (type === 1) {
                this.isManuacall = true;
              } else {
                this.isManuacallType = true;
              }
            }
          });
        })
        .catch(() => {
          this.$message({
            type: 'info',
            message: '取消拨打电话',
          });
        });
    },
    formatDateData(time) {
      const now_data = new Date().getTime();
      const my_time = now_data - new Date(time).getTime();
      const hours = my_time / 1000 / 60 / 60;
      const hoursRound = Math.floor(hours);
      const minutes = my_time / 1000 / 60 - 60 * hoursRound;
      const minutesRound = Math.floor(minutes);
      const seconds = (
        my_time / 1000 -
        60 * 60 * hoursRound -
        60 * minutesRound
      ).toFixed(0);

      if (hoursRound > 0 && minutesRound > 0) {
        // return hoursRound + '小时' + minutesRound + '分' + seconds + '秒';
        return hoursRound + '小时';
      }
      if (hoursRound == 0 && minutesRound > 0) {
        return minutesRound + '分钟';
      }
      if (hoursRound == 0 && minutesRound == 0) {
        return seconds + '秒';
      }
    },
    down() {
      this.timer = setInterval(() => {
        const nowData = new Date().getTime();
        const timeleft = this.item.appointBeginTime - nowData;
        if (timeleft < 120000 && nowData < this.item.appointEndTime) {
          this.isCall = true;
          clearInterval(this.timer);
        }
      }, 1000);
    },
    getInfo(id) {
      return teamDetail({
        tid: this.item.imTeamId,
      })
        .then((res) => {
          if (res.code == '000000') {
            const { memberList } = res.data;
            console.log('---memberList', memberList);
            if (memberList) {
              const accId = memberList.filter((val) => {
                return val.id == id;
              });
              return accId[0].accId;
            }
          }
        })
        .catch(() => {});
    },
    // 主动呼叫 roletype 1：助诊医生 2：接诊医生
    drivingCall(id, roletype) {
      if (roletype == 1 && this.isUserChat) {
        return false;
      }
      if (roletype == 2 && this.isDoctorChat) {
        return false;
      }
      this.getInfo(id).then((res) => {
        const params = {
          imAccId: res,
          imTeamId: this.item.imTeamId,
          liveRoomId: this.item.roomId,
        };
        callDirect(params).then((res) => {
          if (res.code === '000000') {
            if (roletype == 1) {
              this.isUserChat = true;
            } else {
              this.isDoctorChat = true;
            }
          } else {
            this.$message({
              message: res.message,
              type: 'warning',
            });
          }
        });
      });
    },
    openChat() {
      if (this.showChat) {
        this.$message({
          message: '不可同时进入多个诊室，请先退出已进入的诊室，再试。',
          type: 'warning',
          duration: 1000,
        });
        return false;
      }
      const i = this.item;
      this.$store.dispatch('main/gotoInquiry', i);
    },
    waitPersonFun() {
      if (!this.isShowWait) {
        const parms = {
          assistantBeginTime: this.item.appointBeginTime,
          doctorId: this.item.doctorId,
        };
        console.log(parms, 'this.item.doctorId');
        waitPersonNum(parms)
          .then((res) => {
            if (res.code === '000000') {
              this.waitPersonList = res.data || [];
            } else {
              this.$message({
                message: res.message,
                type: 'warning',
                duration: 1000,
              });
            }
            this.isShowWait = !this.isShowWait;
          })
          .catch((err) => {
            console.log(err);
            this.isShowWait = !this.isShowWait;
            this.$message({
              message: '服务查询失败',
              type: 'warning',
              duration: 1000,
            });
          });
      }
    },
    // 粘帖文本
    clipboardAction() {
      const _this = this;
      console.log(11);
      clipboard && clipboard.destroy(); //  不是单例的，所以每次都要销毁
      clipboard = new this.ClipboardJS('.copy-orderId', {
        // .footer：文档的CSS类名
        text: function () {
          console.log(_this.item.diagnoseLogId);
          _this.$message.success('复制成功');
          return _this.item.diagnoseLogId; // 要粘贴的文案
        },
      });
    },
  },
};
