export const IM_MESSAGE = {
  PLEASE_ACTION: 100, // 请求连麦-------------------------------------------------------------嘉宾

  CALL_ACTION: 101, // 连麦通知
  CALL_ACCEPT: 1, // 主播同意嘉宾连麦----------------------------------------------------------主播
  CALL_REFUSE: 0, // 主播拒绝嘉宾连麦----------------------------------------------------------主播

  DOWN_ACTIONL: 102, //下麦通知
  DOWN_COMMAND: 102, //让嘉宾下麦-------------------------------------------------------------主播

  CUSTOM_ACTION: 301, //自定义通知
  CUSTOM_COMMAND_MC: 333, //自己下麦----------------------------------------------------------嘉宾
  CUSTOM_COMMAND_IN: 666, // 自已在房间-------------------------------------------------------嘉宾
  CUSTOM_COMMAND_OUT: 999, // 离开房间--------------------------------------------------------嘉宾

  CUSTOM_COMMAND_ON: 777, //上课--------------------------------------------------------------主播
  CUSTOM_COMMAND_DOWN: 888, //下课------------------------------------------------------------主播
  CUSTOM_COMMAND_DOWN_MC: 852, //关闭麦克风----------------------------------------------------主播
  CUSTOM_COMMAND_DOWN_V: 851, // 关闭摄像头 ---------------------------------------------------主播
  CUSTOM_COMMAND_HERE: 123, //嘉宾还在不在-----------------------------------------------------主播
  CUSTOM_COMMAND_YES: 321, //嘉宾还在----------------------------------------------------------嘉宾
  CUSTOM_COMMAND_INVITE: 741, //邀请嘉宾连麦----------------------------------------------------主播
  CUSTOM_COMMAND_INVITE_OK: 742, //嘉宾同意连麦-------------------------------------------------嘉宾
  CUSTOM_COMMAND_INVITE_NO: 743, //嘉宾拒绝连麦-------------------------------------------------嘉宾
  CUSTOM_COMMAND_INVITE_EMPTY: 745, //主播告诉嘉宾有空位置--------------------------------------主播
  CUSTOM_COMMAND_SPEAKER_ON: 201, //主播设置嘉宾为主讲--------------------------------------------主播
  CUSTOM_COMMAND_SPEAKER_DOWN: 202, //主播取消嘉主讲----------------------------------------------主播
}





// 主播发送的消息-------------------------------------------------

export const imAgreeCall = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CALL_ACTION + ',"accept":' + IM_MESSAGE.CALL_ACCEPT + ',"reason":"同意连麦"}', description: '', extension: '' }
  return data
}

export const imRefuseCall = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CALL_ACTION + ',"accept":' + IM_MESSAGE.CALL_REFUSE + ',"reason":"拒绝连麦"}', description: '', extension: '' }
  return data
}

export const imCallDown = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.DOWN_ACTIONL + ', "command":"' + IM_MESSAGE.DOWN_COMMAND + '", "accept":0,"message":"' + nick + '","reason":"下麦"}', description: '', extension: '' }
  return data
}

export const imMcDown = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ',"command": "' + IM_MESSAGE.CUSTOM_COMMAND_DOWN_MC + '","accept":0,"message":"' + nick + '","reason":"主播关闭了您的麦克风"}', description: '', extension: '' }
  return data
}

export const imVDown = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ',"command": "' + IM_MESSAGE.CUSTOM_COMMAND_DOWN_V + '","accept":0,"message":"' + nick + '","reason":"主播关闭了您的摄像头"}', description: '', extension: '' }
  return data
}

export const imClassOn = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_ON + '","accept":0,"reason":"上课啦","message":""}', description: '', extension: '' }
  return data
}

export const imClassDown = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_DOWN + '","accept":0,"reason":"下课啦","message":""}', description: '', extension: '' }
  return data
}

export const imJbHere= () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_HERE + '","accept":0,"reason":"在么？","message":""}', description: '', extension: '' }
  return data
}

export const imInviteCall = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_INVITE + '","accept":0,"reason":"主播请您连麦","message":"' + nick + '"}', description: '', extension: '' }
  return data
}

export const imInviteEmpty= (nick,replaceId) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_INVITE_EMPTY + '","accept":0,"reason":"有空位置了，可以连麦了","replaceId":"' + replaceId + '","message":"' + nick + '"}', description: '', extension: '' }
  return data
}

export const imSetSpeaker= (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_SPEAKER_ON + '","accept":0,"reason":"主播设置您为主讲人","message":"' + nick + '"}', description: '', extension: '' }
  return data
}

export const imCancleSpeaker = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_SPEAKER_DOWN + '","accept":0,"reason":"主播取消您的主讲人身份","message":"' + nick + '"}', description: '', extension: '' }
  return data
}




// 嘉宾发的消息----------------------------------------------------------------------

export const imPleaseCall = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.PLEASE_ACTION + ',"accept":1,"reason":"申请连麦"}', description: '', extension: '' }
  return data
}

export const imInhome = (nick, callStatus, pendCalling, faceUrl, loadingTime, isSpeaker) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ',"command":"' + IM_MESSAGE.CUSTOM_COMMAND_IN + '","accept":1,"reason":"我已经在房间了" ,"message":"' + nick + '","callStatus":"' + callStatus + '","pendCalling":"' + pendCalling + '","isSpeaker":"' + isSpeaker + '","loadingTime":"' + loadingTime + '","faceUrl":"' + faceUrl + '"}', description: '', extension: '' }
  return data
}

export const imMcDownSelf = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_MC + '","accept":0,"reason":"我下麦了","message":""}', description: '', extension: '' }
  return data
}

export const imJbYes = () => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_YES + '","accept":0,"reason":"在的","message":""}', description: '', extension: '' }
  return data
}

export const imInviteOk = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_INVITE_OK + '","accept":0,"reason":"嘉宾接受主播连麦请求","message":"' + nick + '"}', description: '', extension: '' }
  return data
}

export const imInviteNo = (nick) => {
  let data = { data: '{"version":"","action":' + IM_MESSAGE.CUSTOM_ACTION + ', "command":"' + IM_MESSAGE.CUSTOM_COMMAND_INVITE_NO + '","accept":0,"reason":"嘉宾拒绝主播连麦请求","message":"' + nick + '"}', description: '', extension: '' }
  return data
}