// ES6 import
import store from '../';
import storejs from 'storejs';
import io from 'socket.io-client';

let socketTimer = null;
export default {
  namespaced: true,
  state: {
    socketClient: null,
  },
  actions: {
    initSocket ({ commit, rootState }, payload) {
      console.log('-=-=-initSocket次数',)
      const socket = io.connect(payload.url, {
        query: {
          loginUserNum: `diagnose_list_socket_${payload.userId}`
        }
      });
      commit('SET_SOCKET', socket);
      commit('SET_IOLISTION');
    },
  },
  mutations: {
    SET_SOCKET: (state, payload) => {
      window.socketClient = payload;
      state.socketClient = payload;

    },
    SET_IOLISTION: (state, payload) => {
      if(!state.socketClient){
        return false;
      }
      state.socketClient.on("connect", (socket) => {
        console.log ('socket 链接成功',socket);
        console.log ('socketTimer---',socketTimer);
        if(socketTimer){
          clearInterval(socketTimer);
        }
      });
      state.socketClient.on("connect_error", (err) => {
        console.log ('socket connect_error',err);
      });
      state.socketClient.on("disconnect", (socket) => {
        console.log ('socket disconnect----',socket);
        store.commit('socket/RECONNECT_SOCKET');
      });
      state.socketClient.on("diagnose_push_event", (socket) => {
        console.log('diagnose_push_event---', socket);
        const {list,allSize,countRespList} = socket;
        console.log('--_VM', _VM.$route)
        store.commit('updateCurrentDiagList', list);
        store.commit('updateAllSize', allSize);
        store.commit('updateCurrentCalList', countRespList);
      });
      state.socketClient.on("diagnose_call_push_event", (socket) => {
        console.log('diagnose_call_push_event---', socket);
        const l = store.state.noticeList;
        if(l.length >=5){
          l.shift();
        }
        l.push(socket);
        const n = {notifyIndex: l.length, ...socket}
        store.commit('updateNoticeList', l);
        console.log('--_VM', _VM)
        const {path} =_VM.$route;
        console.log("n--------",n)
        const operateUserId=store.state.soketQuest.operateUserId?store.state.soketQuest.operateUserId:''
        if(path && String(path).indexOf('workbench') > -1&&n.operateUserId==operateUserId){
          store.commit('socket/SET_NOTIFY', n);
        }
      });
      state.socketClient.on('ping', function () {
        console.log('[E] 心跳请求已发出 →', true, socketTimer);
        if(socketTimer){
          clearInterval(socketTimer);
        }
      });
      //收到
      state.socketClient.on('pong', function () {
        console.log('[E] 心跳响应已收到 ←', true);
      });
    },
    SET_NOTIFY: (state, payload) => {
      console.log('--payload', payload)
      let doms = document.getElementsByClassName('el-notification')
      if (doms.length >= 5) return
      const h = _VM.$createElement;

      const t = payload.department ? `问诊单${payload.diagnoseLogId}(${payload.department})` : `问诊单${payload.diagnoseLogId}`
      // userCallKfStatus 医助呼叫
      // doctorCallKfStatus 医生呼叫
      let name= payload.userCallKfStatus==1 ? payload.userName:payload.doctorName
      const cn = _VM.$notify({
        title: t,
        message: h("p", [
          h("i", {style: `color: teal;`}, `${name}正在呼叫你`),

          h(
            "el-button",
            {
              style: `float:right;margin-top:${30}px;`,
              on: {
                click: function () {
                  console.log('----state', state)
                  if(state.showChat){
                    _VM.$message({
                      message: '不可同时进入多个诊室，请先退出已进入的诊室，再试。',
                      type: "warning",
                      duration:1000
                    });
                    return false;
                  }
                  store.dispatch('gotoInquiry', payload);
                  cn.close();
                },
              },
            },
            "进入诊室"
          ),
        ]),
        onClose: function () {
          console.log('--onClose',payload )
        },
        duration: 5000,
        position: 'top-right',
      })
    },
    RECONNECT_SOCKET: (state, payload) => {
      if(socketTimer){
        console.log('RECONNECT_SOCKET--已经存在');
      }else{
        const i = storejs.get('initSocketInfo');
        console.log('RECONNECT_SOCKET-- 重新链接', i);
        socketTimer =  setInterval(function (){
          console.log('----initSocketInfo', i);
          store.dispatch( 'socket/initSocket', i)
        }, 2000);
      }
    }
  },
};
