import App from '../App'

// 问诊订单管理
const diagnosisList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-list.vue')), 'diagnosisList')
const diagnosisIm = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-im.vue')), 'diagnosisIm')
const diagnosisLive = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-live.vue')), 'diagnosisLive')
const serviceList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/service-list.vue')), 'serviceList')
const assistList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/assist-list.vue')), 'assistList')
const assistListTemp = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/assist-list-temp.vue')), 'assistListTemp')
const diagnosisEditor = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-editor.vue')), 'diagnosisEditor')
const diagnosisListNew = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-list-new.vue')), 'diagnosisListNew')
const downList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/down-list.vue')), 'downList')

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/diagnosis-list'
        }, {
            path: '/diagnosis-list',
            component: diagnosisList,
            meta: {
                keepAlive: true // 需要被缓存
            }
        }, {
            path: '/diagnosis-im',
            component: diagnosisIm
        }, {
            path: '/diagnosis-live',
            component: diagnosisLive
        }, {
            path: '/service-List',
            component: serviceList
        },  {
            path: '/assist-list',
            component: assistList
        },   {
            path: '/assist-list-temp',
            component: assistListTemp
        }, {
            path: '/diagnosis-editor',
            component: diagnosisEditor
        }, {
            path: '/diagnosis-list-new',
            component: diagnosisListNew
            
        }, {
            path: '/down-list',
            component: downList
        }
    ]
}]
