import App from '../App'

const index = r => require.ensure([], () => r(require('../views/index')), 'index')
const indexOld = r => require.ensure([], () => r(require('../views/index-old')), 'index-old')
const merge = r => require.ensure([], () => r(require('../views/merge-detail')), 'merge')
const shareMerge = r => require.ensure([], () => r(require('../views/share-merge-detail')), 'share-merge')
const test = r => require.ensure([], () => r(require('../views/test-components')), 'test-components')
const courseDetail = r => require.ensure([], () => r(require('../views/course-detail')), 'course-detail')
const notFound = r => require.ensure([], () => r(require('../views/not-found')), 'not-found')
const goodsDetail = r => require.ensure([], () => r(require('../views/goods-detail')), 'goods-detail')
const purchaseRezult = r => require.ensure([], () => r(require('../views/purchase-rezult')), 'purchase-rezult')

const questionBank = r => require.ensure([], () => r(require('../views/question-bank')), 'question-bank')
const questionDetail = r => require.ensure([], () => r(require('../views/question-detail')), 'question-detail')

const couponList = r => require.ensure([], () => r(require('../views/coupon/coupon-list')), 'coupon-list')

// 年度报告（2020）
const asIndex = r => require.ensure([], () => r(require('../views/annual-summary/index')), 'annual-summary-index')
const asShare = r => require.ensure([], () => r(require('../views/annual-summary/share')), 'annual-summary-share')
const asDetail = r => require.ensure([], () => r(require('../views/annual-summary/detail')), 'annual-summary-detail')

export default [{
  path: '/',
  component: App,
  children: [
    {
      path: '',
      redirect: '/index'
    },
    {
      path: '/index',
      component: index
    },
    {
      path: '/index-old',
      component: indexOld
    },
    {
      path: '/home',
      component: index
    },
    {
      path: '/coop',
      component: merge
    },
    {
      path: '/sharecoop',
      component: shareMerge
    },
    {
      path: '/test',
      component: test
    },
    {
      path: '/course-detail',
      component: courseDetail
    },
    {
      path: '/not-found',
      component: notFound
    },
    {
      path: '/goods-detail',
      component: goodsDetail,
      meta: {
        title: '商品详情'
      }
    },
    {
      path: '/prezult',
      component: purchaseRezult
    },
    {
      path: '/question-bank',
      component: questionBank
    },
    {
      path: '/question-detail',
      component: questionDetail
    },
    {
      path: '/coupon-list',
      component: couponList,
      meta: {
        title: '优惠券'
      }
    },

    {
      path: '/as-index',
      component: asIndex,
      meta: {
        title: '年度报告首页'
      }
    },
    {
      path: '/as-share',
      component: asShare,
      meta: {
        title: '年度报告分享页面'
      }
    },
    {
      path: '/as-detail',
      component: asDetail,
      meta: {
        title: '年度报告页面（详情）'
      }
    }
  ]
}]
