import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import '@/utils/rem'					// 引入自适应
import '@/utils/yqy-bridge'				// 移动端服务
import '@/utils/wxShare';
// import FastClick from 'fastclick'
import vueFilters from '@/utils/filter';
import BuriedPoint, { sendBuriedData } from 'web-buried-point';
import Vant from 'vant';
import 'vant/lib/index.css';
import clipboard from 'clipboard';
import { querystring } from '@/utils';
//注册到vue原型上
Vue.prototype.clipboard = clipboard;

if (!(process.env.BUILD_ENV === 'uat' || process.env.BUILD_ENV === 'pro')) {
// if (!(process.env.BUILD_ENV === 'pro')) {
  const VConsole = require('vconsole');
	let vConsole = new VConsole() // 初始化
}

// 可调试
// Vue.config.devtools = true;


// 注册所有公用过滤器
for (let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}

// if ('addEventListener' in document) {
//     document.addEventListener('DOMContentLoaded', function() {
//         FastClick.attach(document.body);
//     }, false);
// }
// Vue.use(DiscussTopicStencil)
Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior(to, from, savedPosition) {
		if (savedPosition) {
			return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
			return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 过滤路由
function fliterRoute(query, path) {
  alert('fliterRoute 111' + JSON.stringify(query) + path);
  let has = false;
  // 登录token保存并替换路径
  if (query.token && query.token != 'undefined') {
    alert('fliterRoute 222 ' + JSON.stringify(query) + path);
    store.dispatch('setToken', query.token);
    delete query.token;
    has = true;
  }
  // 课程详情页去掉projectId
  if (path === '/course-detail' && query.projectId) {
    sessionStorage.setItem('projectId', query.projectId);
    delete query.projectId;
    has = true;
  }
  // 商品详情页去掉code
  if (path === '/goods-detail' && query.code) {
    store.dispatch('getWxUserInfo', query.code);
    delete query.code;
    let goodsDetailParams = sessionStorage.getItem('goodsDetailParams');
    goodsDetailParams = goodsDetailParams ? JSON.parse(goodsDetailParams) : {};
    Object.assign(query, goodsDetailParams);
    has = true;
  }
  return [query, has];
}

router.beforeEach((to, from, next) => {
  alert('beforeEach @@@@@@');
  // 商品页授权登录路由处理
  if (to.path === '/goods-detail') {
    let searchQuery = querystring(location.search);
    if (searchQuery.code) {
      let newUrl = location.origin + location.pathname + '#/goods-detail?code=' + searchQuery.code;
      location.replace(newUrl);
      return;
    }
  }
  let query = { ...to.query };
  // 登录token保存并替换路径
  let [newQuery, has] = fliterRoute(query, to.path);
  if (has) {
    next({ path: to.path, query: newQuery, replace: false });
    return;
  }

  if (to.meta.title) {
    document.title = to.meta.title
  }
  
  next();
})

// 加入混合
Vue.mixin({
	...mixins
})
// import './plugins';

// import { buriedURL } from './apiConfig';
let domain = '';
if (process.env.BUILD_ENV === 'pro') {
	domain = 'https://sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'test') {
	domain = 'https://test1-sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'uat') {
	domain = 'https://uat-sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'dev') {
	domain = 'https://dev-sc.yunqueyi.com';
} else {
	domain = 'https://dev-sc.yunqueyi.com';
}

Vue.use(BuriedPoint, {
	class_name: 'web_app_professional_exam',
	url: `${domain}/file/log/trace1`
});
Vue.prototype.$sendBuriedData = sendBuriedData;

Vue.use(Vant);

new Vue({
	router,
	store,
}).$mount('#app')

