// import fetch from '@/utils/fetch';
// import { getBaseUrl } from '@/utils/index'
// import { setCookie, getCookie, delCookie } from '@/utils/index';
// import { envConfig } from '@/utils/env-config';

const question = {
  state: {
    questionList: [],
    currentQuestion: {
      id: 1,
      type: 1,      // 1: 单选题; 2: 多选题
      isPublic: 0,  // 0: 通用; 1: 共题干; 2: 共答案;
      order: 1,
      isAnalyzed: false,
      isCollected: false,
      answerList: [
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
        {
          isCorrect: true,
          isSelected: false,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
      ]
    },
    currentQuestionIndex: 0,
    questionTotal: 30,
  },
  mutations: {
    SET_QUESTION_LIST: (state, payload) => {
      state.questionList = payload;
    },
    SET_CURRENT_QUESTION: (state, payload) => {
      state.currentQuestion = payload;
    },
    SET_CURRENT_QUESTION_INDEX: (state, payload) => {
      state.currentQuestionIndex = payload;
    },
    SET_QUESTION_TOTAL: (state, payload) => {
      state.questionTotal = payload;
    },
  },
  actions: {
    // 获取用户信息
    async getQuestionList({ commit }, params) {
      console.log(params);
      let currentList = [
        {
          id: 1,
          type: 1,  
          isPublic: 0,
          order: 1,
          isAnalyzed: false,
          isCollected: false,
          answerList: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估",
            },
          ]
        },
        {
          id: 2,
          type: 2,  
          isPublic: 0,
          order: 2,
          isAnalyzed: false,
          isCollected: false,
          answerList: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估2",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估2",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估2",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评3",
            },
          ]
        },
        {
          id: 3,
          type: 1,  
          isPublic: 1,
          order: 3,
          isAnalyzed: false,
          isCollected: false,
          answerList: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估3",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估3",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估3",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估3",
            },
          ]
        },
        {
          id: 4,
          type: 2,  
          isPublic: 2,
          order: 4,
          isAnalyzed: false,
          isCollected: false,
          answerList: [
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估4",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估4",
            },
            {
              isCorrect: true,
              isSelected: false,
              text: "进行分析评估4",
            },
            {
              isCorrect: false,
              isSelected: false,
              text: "进行分析评估4",
            },
          ]
        },
      ];
      commit('SET_QUESTION_LIST', currentList);
      commit('SET_CURRENT_QUESTION', currentList[0] || {answerList:[]});
      commit('SET_CURRENT_QUESTION_INDEX', 0);
      commit('SET_QUESTION_TOTAL', 30);
    },

  },
}

export default question;
