const coop = {
  state: {
    userInfo: {appVersion: "343", userToken: "EFC0A4A5EC4B49FBBBBCD1AD0E46515F"},
    statusBarHeight: {},
    projectTabIndex: 1,
    jumpURLForI: "",    //中华医学会一类跳转地址
    jumpURLForII: "",   //中华医学会二类跳转地址
    positionInfo: {
      accuracy: "",
      address: "",
      city: "",
      city_code: "",
      country: "",
      district: "",
      district_code: "",
      latitude: "",
      longitude: "",
      poi_name: "",
      province: "",
    },
    organizationInfo: {
      provinceId: 0,
      cityId: 0,
      countyId: 0,
      townId: 0,
      organizationId: 0
    }
  },
  mutations: {
    SET_USER_INFO: (state, userInfo) => {
      state.userInfo = userInfo
    },
    SET_STATUS_BAR_HEIGHT: (state, statusBarHeight) => {
      state.statusBarHeight = statusBarHeight
    },
    SET_PROJECT_TAB_INDEX: (state, projectTabIndex) => {
      state.projectTabIndex = projectTabIndex
    },
    SET_JUMP_URL_FOR_I: (state, jumpURLForI) => {
      state.jumpURLForI = jumpURLForI
    },
    SET_JUMP_URL_FOR_II: (state, jumpURLForII) => {
      state.jumpURLForII = jumpURLForII
    },
    SET_POSITION_INFO: (state, positionInfo) => {
      state.positionInfo = positionInfo
    },
    SET_ORGANIZATION_INFO: (state, organizationInfo) => {
      state.organizationInfo = organizationInfo
    },
  },
  actions: {
    setUserInfo({ commit }, userInfo) {
      commit('SET_USER_INFO', userInfo)
    },
    setStatusBarHeight({ commit }, statusBarHeight) {
      commit('SET_STATUS_BAR_HEIGHT', statusBarHeight)
    },
    setProjectTabIndex({ commit }, projectTabIndex) {
      commit('SET_PROJECT_TAB_INDEX', projectTabIndex)
    },
    setJumpURLForI({ commit }, jumpURLForI) {
      commit('SET_JUMP_URL_FOR_I', jumpURLForI)
    },
    setJumpURLForII({ commit }, jumpURLForII) {
      commit('SET_JUMP_URL_FOR_II', jumpURLForII)
    },
    setPositionInfo({ commit }, positionInfo) {
      commit('SET_POSITION_INFO', positionInfo)
    },
    setOrganizationInfo({ commit }, organizationInfo) {
      commit('SET_ORGANIZATION_INFO', organizationInfo)
    },
  }
}

export default coop
