import { Toast } from 'vant';
import fetch from '@/utils/fetch';
import { getBaseUrl } from '@/utils/index'
import { setCookie, delCookie } from '@/utils/index';
import { envConfig } from '@/utils/env-config';

let wxInfo = sessionStorage.getItem('wxInfo');
wxInfo = wxInfo ? JSON.parse(wxInfo) : {};

const user = {
  state: {
    token: localStorage.getItem('token') || '',
    info: {}, // 用户信息
    wxInfo, // 微信信息，openid等
  },
  mutations: {
    SET_TOKEN: (state, payload) => {
      state.token = payload;
    },
    SET_USER_INFO: (state, payload) => {
      state.info = payload;
    },
    SET_WX_INFO: (state, payload) => {
      state.wxInfo = payload;
    },
  },
  actions: {
    // 外部登陆返回设置token
    setToken({ commit, dispatch }, params) {
      commit('SET_TOKEN', params);
      localStorage.setItem('token', params);
      setCookie('token', params)
      dispatch('getUserInfo');
    },
    // 获取用户信息
    async getUserInfo({ state, commit, dispatch }) {
      try {
        const errCallBack = () => {
          dispatch('logout');
          Toast('登录失效，请重新登录~')
        }
        const res = await fetch({
          url: getBaseUrl('account/login/web'),
          method: 'get',
          headers: { token: state.token }
        }).catch(() => {
          errCallBack()
        });
        if (res && res.code === '000000') {
          const { certifyDoc, isExist } = res.data;
          const picapDoctor = res.data.picapDoctor || {};
          if (picapDoctor.id) {
            // let avatar = picapDoctor.avatar_image_url || '';
            let avatarUrl = '';
            // const img1 = await preLoadImg(`https://test-file.yunqueyi.com${avatar}`).catch(err => console.log(err));
            // const img2 = await preLoadImg(`https://file.yunqueyi.com${avatar}`).catch(err => console.log(err));
            // if (img1) {
            //   avatarUrl = img1.src;
            // }
            // if (img2) {
            //   avatarUrl = img2.src;
            // }
            picapDoctor.avatar = avatarUrl || 'https://file.yunqueyi.com/File/doctor_default.png';
            commit('SET_USER_INFO', { ...picapDoctor, isExist, certifyDoc });
          }
        } else {
          errCallBack()
        }
      } catch (err) {
        console.error(err);
      }
    },

    // 通过登陆
    goLogin() {
      window.location.href = envConfig[process.env.BUILD_ENV]['webPageUrl'] + "/pica_login?target_url=" + encodeURIComponent(location.href);
    },

    getWxUserInfo({ state, commit }, code) {
      const type = 15;
      fetch({
        url: getBaseUrl(`wechats/users/info/${type}/${code}`),
        method: 'get',
        headers: { token: state.token }
      }).then(res => {
        console.log('____wx res_____', res.data)
        sessionStorage.setItem('wxInfo', JSON.stringify(res.data));
        commit('SET_WX_INFO', res.data)
      });
    },

    // 登出
    logout({ state, commit }) {
      commit('SET_TOKEN', '');
      commit('SET_USER_INFO', {});
      localStorage.removeItem('token');
      delCookie('token')
    },
  },
}

export default user;
