/* eslint-disable */
import Vue from 'vue'
import request from '@/utils/fetch';
import wx from 'weixin-js-sdk';
import { getWxType } from "@/utils/index";

/** 注入配置信息 */
export const wxConfig = () => {
  /**
   * 各个环境目前获取签名使用： type[dev: 1, test1: 15, uat: 30, prod: 5]
   * 微信类型 1、云鹊医联  5、云鹊健康  10、基层大众版 15、云鹊医 20、基层医生版 25、云鹊慧测试账号 30云鹊医导流公众号
   */
  let type = '&type=' + getWxType(); // type不同，对应的appid不一样，15为线上
  let cCurl= location.href;
  const url = `${location.origin}/annualsummary?${cCurl.split('?')[1]}`;

  console.log('获取签名的url => ', url);
  request({ url: `https://sc.yunqueyi.com/wechats/signs?url=${encodeURIComponent(url)}${type}` }).then(res => {
    let configs = res.data.signMap;
    wx.config({
      debug: false,
      appId: configs.appId,
      nonceStr: configs.nonceStr,
      timestamp: configs.timestamp,
      signature: configs.signature,
      jsApiList: [
        'hideMenuItems',
        'previewImage',
        'checkJsApi',
        'chooseWXPay',
        'onMenuShareTimeline',
        'onMenuShareAppMessage',
        'onMenuShareQQ',
        'onMenuShareWeibo',
        'onMenuShareQZone',
        'getLocation',
        'openLocation',
        'translateVoice'
      ],
      openTagList: ['wx-open-launch-app', 'wx-open-launch-weapp'],
    });
  });

};

/**
 * wxShare 分享
 * @param option
 */
export const wxShare = (option = {}, successCB = () => {}) => {
  wx.ready(() => {
    // 分享给朋友
    wx.onMenuShareAppMessage({
      title: option.title,
      desc: option.desc,
      link: option.link,
      imgUrl: option.imgUrl,
      success: function(res) {
        // 用户确认分享后执行的回调函数
        successCB(res);
      },
      cancel: function() {
        // 用户取消分享后执行的回调函数
      },
      fail: function (res) {
        console.log('分享失败',JSON.stringify(res));
      }
    });

    // 分享到朋友圈
    wx.onMenuShareTimeline({
      title: option.friendtitle || option.title, // 标题
      desc: option.desc,
      link: option.link, // 链接
      imgUrl: option.imgUrl, // 分享图标
      success: function(res) {
        successCB(res);
      },
      cancel: function() {
        // 用户取消分享后执行的回调函数
      }
    });
  });
  wx.error((res) => {
    console.log('wx.error res => ', res);
  })
};

export const wxDisabledShare = () => {
  wx.ready(() => {
    wx.hideMenuItems({
      menuList: [
        'menuItem:share:appMessage',
        'menuItem:share:timeline',
        'menuItem:share:qq',
        'menuItem:share:weiboApp',
        'menuItem:share:QZone'
      ]
    });
  });
};

/**
 *
 * @param source
 * @param option
 */
export const wechatShare = async (option = {}, successCB = () => {}) => {
  const shareOption = {
    link: location.href,
    title: `云鹊医！`,
    friendtitle: `讨论进行中，速来围观！`,
    desc: '参与讨论，一起畅谈医学那些事！快来看看吧~',
    imgUrl: 'https://file.yunqueyi.com/logo.png',

    ...option
  };
  wxConfig();
  wxShare(shareOption, successCB);
};

Vue.prototype.wechatShare = wechatShare


