/* eslint-disable */
import Vue from 'vue'
import request from '@/utils/fetch';
import wx from 'weixin-js-sdk'
import { getBaseUrl } from "@/utils/index";
import weixinJsSdk from 'weixin-js-sdk';
/** 注入配置信息 */
export const wxConfig = (link) => {
  // const params = { resetURI: true, url: encodeURIComponent(location.href) };
  //  上线前是需要把域名改为线上的sc
  let baseUrl = getBaseUrl("");
  // request({ url: `https://sc.yunqueyi.com/wechats/signs?url=${encodeURIComponent(link)}` }).then(res => {
  request({ url: `${baseUrl}/wechats/signs?url=${encodeURIComponent(link)}` }).then(res => {
    let configs = res.data.signMap;
    wx.config({
      debug: false,
      appId: configs.appId,
      nonceStr: configs.nonceStr,
      timestamp: configs.timestamp,
      signature: configs.signature,
      jsApiList: [
        'hideMenuItems',
        'previewImage',
        'checkJsApi',
        'chooseWXPay',
        'onMenuShareTimeline',
        'onMenuShareAppMessage',
        'onMenuShareQQ',
        'onMenuShareWeibo',
        'onMenuShareQZone',
        'getLocation',
        'openLocation',
        'translateVoice'
      ]
    });
  });;

};

/**
 * wxShare 分享
 * @param option
 */
export const wxShare = (option = {}, successCB = () => {}) => {
  wx.ready(() => {
    // 分享给朋友
    wx.onMenuShareAppMessage({
      title: option.title,
      desc: option.desc,
      link: option.link,
      imgUrl: option.imgUrl,
      success: function(res) {
        // 用户确认分享后执行的回调函数
        successCB(res);
      },
      cancel: function() {
        // 用户取消分享后执行的回调函数
      }
    });

    // 分享到朋友圈
    wx.onMenuShareTimeline({
      title: option.friendtitle || option.title, // 标题
      desc: option.desc,
      link: option.link, // 链接
      imgUrl: option.imgUrl, // 分享图标
      success: function(res) {
        successCB(res);
      },
      cancel: function() {
        // 用户取消分享后执行的回调函数
      }
    });
  });
};

function wxHideMenu() {
  wx.ready(() => {
    WeixinJSBridge.call('hideOptionMenu');
  });
}

export const wxDisabledShare = () => {
  wx.ready(() => {
    wx.hideMenuItems({
      menuList: [
        'menuItem:share:appMessage',
        'menuItem:share:timeline',
        'menuItem:share:qq',
        'menuItem:share:weiboApp',
        'menuItem:share:QZone',
        'menuItem:copyUrl',
        'menuItem:openWithQQBrowser',
        'menuItem:openWithSafari',
      ]
    });
  });
};

/**
 *
 * @param source
 * @param option
 */
export const wechatShare = (option = {}, successCB = () => {}, hideMenu) => {
  const shareOption = {
    link: location.href,
    title: `云鹊医！`,
    friendtitle: `讨论进行中，速来围观！`,
    desc: '参与讨论，一起畅谈医学那些事！快来看看吧~',
    imgUrl: 'https://file.yunqueyi.com/logo.png',

    ...option
  };
  wxConfig(shareOption.link);
  if (hideMenu) {
    wxHideMenu()
  } else {
    wxShare(shareOption, successCB);
  }
};

Vue.prototype.wechatShare = wechatShare;
Vue.prototype.wxDisabledShare = wxDisabledShare;



