import App from '../App'

// 年度报告（2020）
const asIndex = r => require.ensure([], () => r(require('../views/annual-summary/index')), 'annual-summary-index')
const asShare = r => require.ensure([], () => r(require('../views/annual-summary/share')), 'annual-summary-share')
const asDetail = r => require.ensure([], () => r(require('../views/annual-summary/detail')), 'annual-summary-detail')

export default [{
  path: '/',
  component: App,
  children: [
    {
      path: '',
      redirect: '/index'
    },
    {
      path: '/index',
      component: asIndex
    },
    {
      path: '/as-index',
      component: asIndex,
      meta: {
        title: '年度报告首页'
      }
    },
    {
      path: '/as-share',
      component: asShare,
      meta: {
        title: '年度报告分享页面'
      }
    },
    {
      path: '/as-detail',
      component: asDetail,
      meta: {
        title: '年度报告页面（详情）'
      }
    }
  ]
}]
