import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import '@/utils/rem'					// 引入自适应
import '@/utils/yqy-bridge'				// 移动端服务
import '@/utils/wxShare';
import vueFilters from '@/utils/filter';
import BuriedPoint, { sendBuriedData } from 'web-buried-point';
import Vant from 'vant';
import 'vant/lib/index.css';
// import clipboard from 'clipboard';
import { querystring } from '@/utils';
import 'swiper/swiper-bundle.css';
import PicaCallApp, { callApp } from 'pica-call-app';
Vue.prototype.$callApp = callApp;

// Vue.prototype.clipboard = clipboard;

const envList = ['dev', 'test', 'uat'];
const { BUILD_ENV } = process.env;
if (envList.indexOf(BUILD_ENV) != -1) {
  const VConsole = require('vconsole');
  new VConsole();
}

// 可调试
// Vue.config.devtools = true;

// 注册所有公用过滤器
for (let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}

Vue.config.ignoredElements = [
  'wx-open-launch-app',
];

Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior(to, from, savedPosition) {
		if (savedPosition) {
			return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
			return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 过滤路由
function fliterRoute(query, path) {
  console.log('fliterRoute 111' + JSON.stringify(query) + path);
  let has = false;
  // 登录token保存并替换路径
  if (query.token && query.token != 'undefined') {
    console.log('fliterRoute 222 ' + JSON.stringify(query) + path);
    store.dispatch('setToken', query.token);
    delete query.token;
    has = true;
  }
  return [query, has];
}

router.beforeEach((to, from, next) => {
  console.log('beforeEach @@@@@@');
  let query = { ...to.query };
  // 登录token保存并替换路径
  let [newQuery, has] = fliterRoute(query, to.path);
  if (has) {
    next({ path: to.path, query: newQuery, replace: false });
    return;
  }

  if (to.meta.title) {
    document.title = to.meta.title
  }
  
  next();
})

// 加入混合
Vue.mixin({
	...mixins
})
// import './plugins';

// import { buriedURL } from './apiConfig';
let domain = '';
if (process.env.BUILD_ENV === 'pro') {
	domain = 'https://sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'test') {
	domain = 'https://test1-sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'uat') {
	domain = 'https://uat-sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'dev') {
	domain = 'https://dev-sc.yunqueyi.com';
} else {
	domain = 'https://dev-sc.yunqueyi.com';
}

Vue.use(BuriedPoint, {
	class_name: 'web_app_annual_summary',
	url: `${domain}/file/log/trace1`
});
Vue.prototype.$sendBuriedData = sendBuriedData;

Vue.use(Vant);

new Vue({
	router,
	store,
}).$mount('#app')

