import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import '@/utils/rem'					// 引入自适应
import '@/utils/yqy-bridge'				// 移动端服务
// import FastClick from 'fastclick'
import vueFilters from '@/utils/filter'
import VConsole from 'vconsole/dist/vconsole.min.js'
import BuriedPoint,{ sendBuriedData} from 'web-buried-point';
import Vant from 'vant';
import 'vant/lib/index.css';
import clipboard from 'clipboard';
//注册到vue原型上
Vue.prototype.clipboard = clipboard;

// if(!(process.env.BUILD_ENV === 'uat' || process.env.BUILD_ENV === 'pro')) {
if(!(process.env.BUILD_ENV === 'pro')) {
	let vConsole = new VConsole() // 初始化
}

// 可调试
// Vue.config.devtools = true;



// 注册所有公用过滤器
for(let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}

// if ('addEventListener' in document) {
//     document.addEventListener('DOMContentLoaded', function() {
//         FastClick.attach(document.body);
//     }, false);
// }
// Vue.use(DiscussTopicStencil)
Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 加入混合
Vue.mixin({
	...mixins
})
// import './plugins';

// import { buriedURL } from './apiConfig';
let domain = '';
if (process.env.BUILD_ENV === 'pro') {
  domain = 'https://sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'test') {
  domain = 'https://test1-sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'uat') {
  domain = 'https://uat-sc.yunqueyi.com';
} else if (process.env.BUILD_ENV === 'dev') {
  domain = 'https://dev-sc.yunqueyi.com';
} else {
  domain = 'https://dev-sc.yunqueyi.com';
}

Vue.use(BuriedPoint, {
  class_name: 'web_app_cme',
  url: `${domain}/file/log/trace1`
});
Vue.prototype.$sendBuriedData = sendBuriedData;

Vue.use(Vant);

new Vue({
	router,
	store,
}).$mount('#app')

