import axios from 'axios'
import store from '../store'
// import { getHostnameAndPort } from '../utils'
// axios.defaults.withCredentials = true

const service = axios.create({
  // baseURL: process.env.BASE_API
  timeout: 600000,
  withCredentials: false
})

// request拦截器
service.interceptors.request.use(config => {
  // debugger
  if (config.data && config.data.setEntry) {
    config.headers['sysCode'] = config.data.sysCode || 10
    if(config.data.token){
       config.headers['token'] = config.data.token || '0F32D60C3D7042158BCF1FB574E482BE'
       if( process.env.BUILD_ENV == "development" ){  // 本地开发环境
        config.headers['token'] = config.data.token || '68659175C0D94E9998CE2C9E3F5C6533';
       }
      //  delete config.data.token;
    }
   
    config.headers['deviceInfo'] = JSON.stringify({ "app_channel": "", "app_mac": "", "app_uuid": "", "app_version": "", "device_brand": "", "device_ip": "", "device_model": "", "device_net": "", "device_ops": "", "resolution_wh": "", "system_level": "", "device_type": '10' })
  }
  return config
}, error => {
  console.debug('service.interceptors.request: ', error)
  Promise.reject(error)
})

// respone拦截器
service.interceptors.response.use(
  response => {
    const res = response.data
    /*  
      baseUrl时，返回000000为成功
      apiUrl时，返回200为成功
    */    
    if (res.code !== '000000' && response.respCode === 200) {
      return Promise.reject('error')
    } else {
      return response.data
    }
  },
  error => {
    console.error('err' + error)
    return Promise.reject(error)
  }
)
export default service
