import $http from 'mn-template/plugins/http';

// 获取亲友列表
export const listRelatives = () =>
  $http({
    method: 'get',
    url: '/splitter/live/v2/list',
    params: {
      version: '3.2.1',
    },
  });

export const getWidgetList = async ({ id, token }) =>
  $http({
    method: 'get',
    url: `/contents/template/${id}/widgetList?token=${token}&setEntry=true`,
  });

export const getWidgetListTab = async ({ id }) =>
  $http({
    method: 'get',
    url: `/contents/template/element/${id}/widgetList`,
  });

export const selectAppModuleParam = async ({ id, token }) =>
  $http({
    method: 'get',
    url: `/contents/contentAppModule/selectAppModuleParam?id=${id}&token=${token}&setEntry=true`,
    withCredentials: true,
  });

// 任务列表查询
export const getActivityDesc = async (data) =>
  $http({
    method: 'get',
    url: `/campaign/admin/task/h5/activityInfo?id=${data.id}&token=${data.token}&setEntry=true`,
    headers: {
      token: data.token,
    },
    // withCredentials: true
  });

// 新的任务列表查询
export const getNewActivityDesc = async (data) =>
  $http({
    method: 'get',
    url: `/campaign/tims/timsActivityInfo?activityId=${data.id}&token=${
      data.token
    }&setEntry=true&random=${Math.random()}`,
    headers: {
      token: data.token,
    },
  });

export const checkQualification = async ({ token, role, rosterId }) =>
  $http({
    method: 'get',
    url: `contents/template/checkQualification?token=${token}&setEntry=true&role=${role}&rosterId=${rosterId}`,
    withCredentials: true,
  });

export const checkToken = async (token) =>
  $http({
    method: 'get',
    url: `campaign/admin/task/checkToken?token=${token}`,
    withCredentials: true,
  });

export const logPut = async (data) =>
  $http({
    method: 'PUT',
    data: data,
    url: 'log/',
  });

export const getRole = async ({ token }) =>
  $http({
    method: 'get',
    url: `/contents/template/getRole?token=${token}`,
    headers: {
      token,
    },
    // withCredentials: true
  });

export const sayHello = async ({ token }) =>
  $http({
    method: 'POST',
    // withCredentials: true,
    headers: {
      token,
    },
    data: {
      token,
    },
    url: '/diplomat/oauth/sayhello?app_id=pica-crrs',
  });

export const getAmountApi = async ({ a, b, c, d }) => {
  // a:url  b:get or post  c:params

  if (b == 'get') {
    const param = JSON.parse(c);
    let str, key;
    for (key in param) {
      str = str + key + '=' + param[key] + '&';
    }
    str = str.slice(0, str.length - 1);
    return $http({
      url: a + '?' + str,
    });
  } else if (b == 'post') {
    return $http({
      method: 'POST',
      headers: {
        token: d,
      },
      data: JSON.parse(c),
      url: a,
    });
  }
};

export const checkHasAgreementApi = async ({ token }) =>
  $http({
    url: 'smartcontract/protocol/sign/check?type=3', // 3为云鹊医隐私协议
    headers: {
      token,
    },
  });

// 查看直播状态
export const checkLiveStatus = async (resourceId) =>
  $http({
    url: `campaign/subscribe/liveStatus?liveId=${resourceId}`,
  });

// 查看doctorId
export const getDoctorId = async (token) =>
  $http({
    url: 'campaign/subscribe/getId',
    headers: {
      token,
    },
  });
// 校验预约和分享完成状态以及直播状态
export const checkFinishStatus = async (data) =>
  $http({
    // alert('token'+data.token)

    // url: `/campaign/admin/tims/checkFinishStatus?type=${type}&resourcesId=${resourcesId}&doctorId=${doctorId}&setEntry=true`,
    url: '/campaign/subscribe/checkFinishStatus',
    method: 'POST',
    headers: {
      token: data.token,
    },
    data: {
      type: data.type,
      resourcesId: data.resourcesId,
      doctorId: data.doctorId,
    },
  });

// 预约
export const getSubscribe = async (data) =>
  $http({
    // url: `/campaign/admin/tims/checkFinishStatus?type=${type}&resourcesId=${resourcesId}&doctorId=${doctorId}&setEntry=true`,
    url: '/campaign/subscribe/',
    method: 'POST',
    headers: {
      token: data.token,
    },
    data: {
      type: data.type,
      resourcesId: data.resourcesId,
      doctorId: data.doctorId,
      shareDoctorId: data.shareDoctorId,
      subscribeUrl: data.subscribeUrl,
    },
  });

// 分享
export const getSubscribeShare = async (data) =>
  $http({
    url: '/campaign/subscribe/share',
    method: 'POST',
    headers: {
      token: data.token,
    },
    data: {
      type: data.type,
      resourcesId: data.resourcesId,
      doctorId: data.doctorId,
    },
  });
// 获取打卡状态 参数 activityId 活动id ,id 任务id
export const getClockStatus = (params) =>
  $http({
    url: `/campaign/clock/v1/${params.activityId}/status/${params.id}`,
    method: 'get',
    withCredentials: true,
  });

// 去打卡 参数 activityId 活动id ,id 任务id
export const goToUpdateClock = (params) =>
  $http({
    url: 'campaign/clock/clock',
    method: 'post',
    data: params,
    withCredentials: true,
  });

// 获取doctorId
export const getDoctorIdObtain = async () =>
  $http({
    url: '/campaign/second-award/doctorId',
    method: 'get',
    withCredentials: true,
  });

// 记录分享行为
export const recordShareAction = (params) =>
  $http({
    url: '/contents/template/share-log',
    method: 'post',
    data: params,
    withCredentials: true,
  });

// 根据邀请组件id返回口令
export const getCommand = async (params) =>
  $http({
    url: '/contents/template/invite-token',
    method: 'get',
    params: params,
    withCredentials: false,
  });

// 根据商品id批量查询商品信息
export const getGoodsDetailListByIds = async (ids) =>
  $http({
    url: 'store/medications/queryGoodsDetailListByIds',
    method: 'post',
    data: ids,
    withCredentials: true,
  });

// 获取和药代相关的积木id列表
export const getTemplateList = async (params) =>
  $http({
    url: '/broker/templateList',
    method: 'get',
    params: params,
    withCredentials: false,
  });

// 校验是否为药代身份并返回加密医生id
export const checkBroker = async (templateId) =>
  $http({
    url: `/broker/checkBroker?templateId=${templateId}`,
    method: 'get',
    withCredentials: true,
  });
