import qs from 'qs';
import request from './api';

export const getHospital = async (params) => {
  let query = { pageNum: 1, pageSize: 1, ...params };
  const str = qs.stringify(query);
  
  return request({ url: `/api-ws/hospitals/?${str}` });
};

/**
 * 获取省列表
 */
export const getProvinceList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取市列表
 */
export const getCityList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取县/区列表
 */
export const getCountyList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取乡镇列表
 */
export const getTownList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取区域（一般是乡镇）下的机构列表
 */
export const getOrgListByTownId = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `/basic-data/position/towns`
  });
};

/**
 * 总体情况-选择地区下
 */
export const getGeneralData = async data => {
  return request({
    // baseURL: 'http://10.177.11.156:10443/',
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/general`
  });
};

/**
 * 根据地区获取机构列表
 */
export const getHospitalsByRegionId = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region/hospital`
  });
};

/**
 * 人群分析
 */
export const getUserAnalysis = async data => {
  return request({
    // baseURL: 'http://10.177.11.156:10443/',
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/userAnalysis`
  });
};
