const { NUXT_ENV_APP } = process.env;

export const BASE_URL = {
  dev: 'https://dev-sc.yunqueyi.com',
  test: 'https://test1-sc.yunqueyi.com',
  uat: 'https://uat-sc.yunqueyi.com',
  prod: 'https://sc.yunqueyi.com'
};

export const SHARE_URL = {
  dev: 'https://dev-phome.yunqueyi.com',
  test: 'https://test1-phome.yunqueyi.com',
  uat: 'https://uat-phome.yunqueyi.com',
  prod: 'https://phome.yunqueyi.com',
}

export const  KF_ACCID_LIST = {
  dev: 'picakf_dev',
  test: 'picakf_test',
  uat: 'picakf_uat',
  prod: 'picakf',
}

export const kfAccid = KF_ACCID_LIST[NUXT_ENV_APP];


export function getShareUrl() {
  return SHARE_URL[NUXT_ENV_APP]
}

export const API_CONFIG = {
  baseURL: BASE_URL[NUXT_ENV_APP],
  headers: {
    'X-Requested-With': 'XMLHttpRequest',
    'Content-Type': 'application/json;charset=UTF-8'
  },
  timeout: 10000,
  withCredentials: false,
  responseType: 'json',
  method: 'get'
}

export const REPONSE_CODE = {
  400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
  401: '用户没有权限（登录过期、token错误）',
  403: '用户得到授权，但是访问是被禁止的。',
  404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
  406: '请求的格式不可得。',
  410: '请求的资源被永久删除，且不会再得到的。',
  422: '当创建一个对象时，发生一个验证错误。',
  500: '服务器发生错误，请检查服务器。',
  502: '网关错误。',
  503: '服务不可用，服务器暂时过载或维护。',
  504: '网关超时。'
};

