export const state = () => ({
  projectId: '',
  regionId: '',
  userToken: '',
  userMobile: '',
})
export const getters = {
  projectId(state) {
    return state.projectId
  },
  regionId(state) {
    return state.regionId
  },
  userToken(state) {
    return state.userToken
  },
  userMobile(state) {
    return state.userMobile
  }
}
export const mutations = {
  SET_PROJECT_ID(state, projectId) {
    state.projectId  = projectId
  },
  SET_REGION_ID(state, regionId) {
    state.regionId  = regionId
  },
  SET_USER_TOKEN(state, userToken) {
    state.userToken  = userToken
  },
  SET_USER_MOBILE(state, userMobile) {
    state.userMobile  = userMobile
  },
}
export const actions = {
  setProjectId({ commit },  projectId) {
    commit('SET_PROJECT_ID', projectId);
  },
  setRegionId({ commit }, regionId) {
    commit('SET_REGION_ID', regionId);
  },
  setUserToken({ commit }, userToken) {
    commit('SET_USER_TOKEN', userToken);
  },
  setUserMobile({ commit }, userMobile) {
    commit('SET_USER_MOBILE', userMobile);
  },
}