import qs from 'qs';
import request from './api';

export const getHospital = async (params) => {
  let query = { pageNum: 1, pageSize: 1, ...params };
  const str = qs.stringify(query);
  
  return request({ url: `/api-ws/hospitals/?${str}` });
};

/**
 * 获取省列表
 */
export const getProvinceList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取市列表
 */
export const getCityList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取县/区列表
 */
export const getCountyList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取乡镇列表
 */
export const getTownList = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region`
  });
};

/**
 * 获取区域（一般是乡镇）下的机构列表
 */
export const getOrgListByTownId = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `/basic-data/position/towns`
  });
};

/**
 * 总体情况-选择地区下
 */
export const getGeneralData = async data => {
  return request({
    // baseURL: 'http://10.177.11.156:10443/',
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/general`
  });
};

/**
 * 根据地区查询机构
 */
export const getHospitalsByRegionId = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region/hospital`
  });
};

/**
 * 人群分析
 */
export const getUserAnalysis = async data => {
  return request({
    // baseURL: 'http://10.177.11.156:10443/',
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/userAnalysis`
  });
};


/**
 * 根据地区查询地区下是否有机构
 */
export const getHospitalsCNT = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region/hospitals/cnt`
  });
};

/**
 * 总体情况-选择机构下人员情况
 */
export const getGeneralPersonal = async data => {
  return request({
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/generalPersonal/${data.pageCfg.type}/${data.pageCfg.pageNo}/${data.pageCfg.pageSize}`
  });
};

/**
 * 总体情况-课程分析接口
 */
export const getGeneralCourse = async data => {
  return request({
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/course`
    // url: `stats/report/course/0/0`
  });
};

/**
 * 总体情况-考试分析接口
 */
export const getGeneralExam = async data => {
  return request({
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/exam`
  });
};

/**
 * 总体情况-考试分析考试列表
 */
export const getGeneralExamList = async data => {
  return request({
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/exam/list`
  });
};

/**
 * 总体情况-考试分析接口（单个机构）
 */
export const getGeneralExamSingle = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/report/exam/${params.projectId}/${params.hospitalId}`
  });
};


/**
 * 查询用户信息和权限
 */
export const getProjectInfo = async params => {
  return request({
    method: 'get',
    params: params,
    withCredentials: true,
    url: `stats/region/info`
  });
};

/**
 * 学习效果分析
 */
export const getStudyEffect = async data => {
  return request({
    method: 'post',
    data: data,
    withCredentials: true,
    url: `stats/report/studyEffect`
  });
};