import { getShareUrl } from './enumerate'

export const getSearchByName = name => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};

export const getItem = name => {
  if (!name) return;
  const v = sessionStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};

export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  sessionStorage.setItem(name, value);
};

export const removeItem = name => {
  if (!name) return;
  sessionStorage.removeItem(name);
};

export const echartColors = [
  "#F6BD16",
  "#39AF9A",
  "#5D7092",
  "#1865FF",
  "#6DC8EC",
  "#E8684A",
  "#FFB01B"
]


export function goPageByNative(vm, pageSubUrl){
  let url = getShareUrl() + pageSubUrl;
  console.log('##########', url)
  let paramList = [
    {
      "key":"pageUrl",
      "value": url,
      "type":4,
      "seqNo":1
    },{
      "key":"showTitle",
      "value": false,
      "type":1,
      "seqNo":2
    },{
      "key":"title",
      "value": '',
      "type":1,
      "seqNo":3
    }
  ]
  vm.$rocNative.dispatchEventByModuleCode && vm.$rocNative.dispatchEventByModuleCode({
      modeCode: 'M300',
      jsonString: paramList
  })
}