var axios=require('axios');
// 整理路由
const routerObj={};
let baseUrl='';
let port = (process.env.PORT == "80" || process.env.PORT == "443" ) ? '' : (":"+process.env.PORT)
let fullHost=process.env.HOST+port; 
let projectName=require("../package.json").name 
//production
// 处理路由children
function allRouter(ele){
  for(var i=0;i< ele.length;i++){
        if(ele[i].path){
          //let key= baseUrl+spath+(spath ? "/" : '')+ele[i].path;
          let key= ele[i].path;
          routerObj[key]= key;
        }
  }
};
// 处理路由
function handleAllRouter(ObjParms){
  // baseUrl
  baseUrl=ObjParms.baseUrl || '';
  let fhost= ObjParms.fullHost||fullHost;
  allRouter(ObjParms.routes,'');
  if(baseUrl.substr(baseUrl.length-1,1)=="/"){
    baseUrl=baseUrl.substr(0,baseUrl.length-1)
  }
  let arr=[];
  for(var key in routerObj){
    let optionObj={};
    optionObj.url=routerObj[key];
    optionObj.fullPath=fhost+baseUrl+routerObj[key]
    optionObj.host=fhost;
    arr.push(optionObj)
  }
  sendAllRouterInfo(arr)
};
// 发送请求
function sendAllRouterInfo(data){
  let url="https://dev-sc.yunqueyi.com/basic-data/menuCode/upload";
  if(process.env.NUXT_ENV_APP!="development"){
    url="https://sc.yunqueyi.com/basic-data/menuCode/upload";
  }
  let obj={
    projectName:projectName,
    menuCodeDtoList:data
  }
  axios({
    method: 'post',
    url:url,
    data: obj
  }).then(res=>{
    console.log("请求接口成功了",res.data)
    return 
  }).catch(err=>{
    console.log("请求接口失败了")
    return 
  });
};

//  定制化路由 
//  [{
//    path:"/capital",
//    meta:{isMountedReport:true,callback:()=>{return []}}
//  }]
module.exports= handleAllRouter
