import { router, vueApp } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import { headerConfigByMeta } from 'mn-template/util/routerUtil';
import { delCookie, setCookie } from '@/utils';

const routerConfig = [
  {
    path: '*',
    redirect: process.env.VUE_APP_BASE_ROUTE,
  },
  {
    path: '/',
    name: 'index',
    meta: {
      title: '学情报告',
      content: [
        {
          name: '客服',
          outShow: true,
        },
      ],
    },
    component: () => import('@/views/index'),
  },
  {
    path: '/examscore',
    name: 'examscore',
    meta: {
      title: '完成项目考试分数情况',
    },
    component: () => import('@/views/examscore'),
  },
  {
    path: '/examtimes',
    name: 'examtimes',
    meta: {
      title: '完成项目考试次数情况',
    },
    component: () => import('@/views/examtimes'),
  },
  {
    path: '/klgpoint',
    name: 'klgpoint',
    meta: {
      title: '培训前后知识点掌握情况',
    },
    component: () => import('@/views/klgpoint'),
  },
  {
    path: '/prolist',
    name: 'prolist',
    meta: {
      title: '专项合作',
      content: [
        {
          name: '客服',
          outShow: true,
        },
      ],
    },
    component: () => import('@/views/prolist'),
  },
  {
    path: '/rankdays',
    name: 'rankdays',
    meta: {
      title: '完成天数排名',
    },
    component: () => import('@/views/rankdays'),
  },
  {
    path: '/rankedu',
    name: 'rankedu',
    meta: {
      title: '项目情况排名',
    },
    component: () => import('@/views/rankedu'),
  },
];

router.beforeEach(async (to, from, next) => {
  headerConfigByMeta(to);

  if (vueApp.$rocNative?.getUserInfo) {
    try {
      const params = await vueApp.$rocNative.getUserInfo();
      delCookie('conslToken');
      setCookie('conslToken', params.userToken);
    } catch (err) {
      console.warn('getUserInfo error:', err);
    }
  } else {
    console.warn('getUserInfo method not available');
  }

  next();
  // vueApp.$rocNative.getUserInfo &&
  //   vueApp.$rocNative.getUserInfo().then((params) => {
  //     delCookie('conslToken');
  //     setCookie('conslToken', params.userToken);
  //     next();
  //   });
});

router.addRoutes(routerConfig);
