import { router } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
try {
  const originalPush = router.prototype.push;
  router.prototype.push = function push(location) {
    return originalPush.call(this, location).catch((err) => err);
  };
} catch (error) {
  console.log(error);
}

const routerConfig = [
  {
    path: '*',
    redirect: process.env.VUE_APP_BASE_ROUTE,
  },
  {
    path: '/',
    name: 'index',
    meta: {
      title: '学情报告',
    },
    component: () => import('@/views/prolist'),
  },
  {
    path: '/examscore',
    name: 'examscore',
    meta: {
      title: '完成项目考试分数情况',
    },
    component: () => import('@/views/examscore'),
  },
  {
    path: '/examtimes',
    name: 'examtimes',
    meta: {
      title: '完成项目考试次数情况',
    },
    component: () => import('@/views/examtimes'),
  },
  {
    path: '/klgpoint',
    name: 'klgpoint',
    meta: {
      title: '培训前后知识点掌握情况',
    },
    component: () => import('@/views/klgpoint'),
  },
  {
    path: '/prolist',
    name: 'prolist',
    meta: {
      title: '专项合作',
    },
    component: () => import('@/views/prolist'),
  },
  {
    path: '/rankdays',
    name: 'rankdays',
    meta: {
      title: '完成天数排名',
    },
    component: () => import('@/views/rankdays'),
  },
  {
    path: '/rankedu',
    name: 'rankedu',
    meta: {
      title: '项目情况排名',
    },
    component: () => import('@/views/rankedu'),
  },
];
router.addRoutes(routerConfig);
