import { getShareUrl } from './enumerate'

export const getSearchByName = name => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};

export const getItem = name => {
  if (!name) return;
  const v = sessionStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};

export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  sessionStorage.setItem(name, value);
};

export const removeItem = name => {
  if (!name) return;
  sessionStorage.removeItem(name);
};

export const echartColors = [
  "#F6BD16",
  "#39AF9A",
  "#5D7092",
  "#1865FF",
  "#6DC8EC",
  "#E8684A",
  "#FFB01B"
]

// 日期与时间解析函数
export function parseTime(time, cFormat) {
  if (arguments.length === 0) {
    return null
  }
  const format = cFormat || '{y}-{m}-{d} {h}:{i}:{s}'
  let date
  if (typeof time === 'object') {
    date = time
  } else {
    if (('' + time).length === 10) time = parseInt(time) * 1000
    date = new Date(time)
  }
  const formatObj = {
    y: date.getFullYear(),
    m: date.getMonth() + 1,
    d: date.getDate(),
    h: date.getHours(),
    i: date.getMinutes(),
    s: date.getSeconds(),
    a: date.getDay()
  }
  const time_str = format.replace(/{(y|m|d|h|i|s|a)+}/g, (result, key) => {
    let value = formatObj[key]
    if (key === 'a') return ['一', '二', '三', '四', '五', '六', '日'][value - 1]
    if (result.length > 0 && value < 10) {
      value = '0' + value
    }
    return value || 0
  })
  return time_str
}

// 跳转到新的学情报告页面
export function goPageByNative(vm, pageSubUrl){
  let url = getShareUrl() + pageSubUrl;
  let paramList = [
    {
      "key":"pageUrl",
      "value": url,
      "type":4,
      "seqNo":1
    },{
      "key":"showTitle",
      "value": false,
      "type":1,
      "seqNo":2
    },{
      "key":"title",
      "value": '',
      "type":1,
      "seqNo":3
    }
  ]
  vm.$rocNative.dispatchEventByModuleCode && vm.$rocNative.dispatchEventByModuleCode({
      modeCode: 'M300',
      jsonString: paramList
  })
}

// 跳转到原生的学情详情页面
export function goNativePage(vm, config = {id: 1, authType: 1}){
  let paramList = [
    {
      "key":"className",
      "value": 'com.picahealth.yunque.activitys.learnreport.learnreport2.NewLearnReportActivity###NewLearnReportVC.PicaDo',
      "type":4,
      "seqNo":1
    },{
      "key":"id",
      "value": config.id,
      "type":1,
      "seqNo":2
    },{
      "key":"authType",
      "value": config.authType,
      "type": 1,
      "seqNo": 3
    }
  ]
  vm.$rocNative.dispatchEventByModuleCode && vm.$rocNative.dispatchEventByModuleCode({
      modeCode: 'M200',
      jsonString: paramList
  })
}