/**
 * @name: vue-component
 * @author: alan
 * @date: 2021-11-16 18:03
 * @description：vue-component
 * @update: 2021-11-16 18:03
 */
import Vue from 'vue';
import PageModel from '@pica-kit/page-model';
import {
  Dialog,
  Toast,
  Popup,
  Icon,
  Button,
  Uploader,
  List,
  Loading,
  Swipe,
  SwipeItem,
} from 'vant';
import { BASE_URL } from '@/utils/enumerate';
import PicaGuideApp, { callApp } from 'pica-guide-app';
// import PicaTopicComment from '@pica-kit/pica-topic-comment';
import PicaTopicStencil from '@pica-kit/pica-topic-stencil';

import WebBuriedPoint, { sendBuriedData } from '@pica-core/web-buried-point';
import PicaH5Login from 'pica-h5-login';
import PicaH5Agreement from 'pica-h5-agreement';
import ClipboardJS from 'clipboard';
const cookies = require('cookie-universal')();
const WX_TYPE_MAP = {
  dev: 1,
  test: 15,
  uat: 30,
  prod: 5,
};
// if(process.env.VUE_APP_CONSOLE){
//   // const VConsole = require('vconsole');
//   // new VConsole();
// }

// Vue.use(PicaCallApp)
Vue.use(PicaGuideApp)
  .use(PicaTopicStencil)
  //  .use(PicaTopicComment)
  .use(PicaH5Login)
  .use(PicaH5Agreement)
  .use(Dialog)
  .use(Toast)
  .use(Icon)
  .use(Popup)
  .use(Loading)
  .use(List)
  .use(Button)
  .use(Uploader)
  .use(Swipe)
  .use(SwipeItem)
  .use(PageModel);

const { VUE_APP_ENV } = process.env;

Vue.use(WebBuriedPoint, {
  class_name: 'template_v2',
  url: `${BASE_URL[VUE_APP_ENV]}/file/log/trace1`,
});

Vue.prototype.$sendBuriedData = sendBuriedData;
Vue.prototype.$cookies = cookies;
Vue.prototype.$callApp = callApp;
Vue.prototype.ClipboardJS = ClipboardJS;
Vue.prototype.$WX_TYPE = WX_TYPE_MAP[VUE_APP_ENV];
