import $http from 'mn-template/plugins/http';
const cookies = require('cookie-universal')();
$http.setDefaults({
  headers: {},
});

// 设置http配置信息 loading、error、clear、encrypt、mockUserInfo
$http.setOptions({
  loading() {
    console.log('我重写了默认的loading');
  },
});

// 新增前置钩子
$http.addBeforeHook((config) => {
  const token = cookies.get('conslToken');
  if (token) {
    config.headers.token = token || '';
  }
  console.log('我是新增的前置钩子', config);
}, 0);

// 新增后置钩子
$http.addAfterHook(
  (response) => console.log('我是新增的后置钩子', response),
  0
);
