import Vue from 'vue';
import { BASE_URL } from '@/utils/enumerate';
import rocNative from '@/utils/jsbridge';
import WebBuriedPoint, { sendBuriedData } from 'web-buried-point';
import { callApp } from 'pica-call-app'; // H5唤起APP组件
import VConsole from 'vconsole/dist/vconsole.min.js';
import jsencrypt from 'jsencrypt';

import {
	CountDown,
	Field,
	Cell,
	CellGroup,
	Button,
	Dialog,
	Toast,
	Checkbox,
	Popup,
	CheckboxGroup,
	RadioGroup,
	Radio,
	Progress,
	ImagePreview,
	Uploader,
	Overlay,
	Loading
} from 'vant';

const { name } = require('../package.json');
const cookies = require('cookie-universal')();
const { NUXT_ENV_APP } = process.env;

if(!(process.env.NODE_ENV === 'uat' || process.env.NODE_ENV === 'pro')) {
// if(!(process.env.BUILD_ENV === 'pro')) {
   let vConsole = new VConsole() // 初始化
}

Vue.prototype.$cookies = cookies;
Vue.prototype.$rocNative = new rocNative();
Vue.prototype.$sendBuriedData = sendBuriedData;
Vue.prototype.$callApp = callApp;
Vue.prototype.$jsencrypt = jsencrypt;

// Vue.use(PicaCallApp);
Vue.use(CountDown).use(Field).use(Cell).use(CellGroup).use(Button).use(Popup).use(Checkbox).use(CheckboxGroup).use(RadioGroup).use(Radio).use(Progress).use(ImagePreview).use(Uploader).use(Overlay).use(Loading);
Vue.use(Toast)
Vue.use(Dialog)

if (name === 'nuxt_ssr') throw Error('需要给当前项目起一个有意义的名称，多英文单词用 _ 拼接，不能有空格。修改文件：package.json (name)');
Vue.use(WebBuriedPoint, {
  class_name: name || 'compaign_ssr',
  url: `${BASE_URL[NUXT_ENV_APP]}/file/log/trace1`
});
