
const { NUXT_ENV_APP } = process.env;
export const getSearchByName = name => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};

export const getItem = name => {
  if (!name) return;
  const v = sessionStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};

export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  sessionStorage.setItem(name, value);
};

export const removeItem = name => {
  if (!name) return;
  sessionStorage.removeItem(name);
};

export const setCookie = (cname,cvalue, exdays = 7, domain = '.yunqueyi.com') => { //yunqueyi.com
  let d = new Date(), expires = '';
  if (NUXT_ENV_APP === 'dev') {
    domain = window.location.hostname;  
  }
  d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
  expires = `expires=${d.toUTCString()}`;
    
  document.cookie = `${cname}=${cvalue};path=/;${expires};domain=${domain}`;
  
}

export const getCookie = (cname) => {
  const reg = new RegExp('(^| )' + cname + '=([^;]*)(;|$)');
  const arr = document.cookie.match(reg);

  return arr ? unescape(arr[2]) : null;
}


export const delCookie = (cname) => {
  var exp = new Date();
        exp.setTime(exp.getTime() - 1);
        var cval = getCookie(cname);
        
        if(cval!=null){
            document.cookie = 'token=; path=/; expires=' + new Date(0).toUTCString();
            document.cookie = 'token=; path=/; domain=.yunqueyi.com; expires=' + new Date(0).toUTCString();
            //document.cookie= name + "="+cval+";path=/;expires="+exp.toGMTString() + ";domain=" + domain;
        } 
}

export const setEventByModuleCode = (itemData, token) => {
  let modeCode = itemData.code || '';
  let paramList = itemData.paramList ? itemData.paramList : '';
  if (modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
    paramList = '';
  } else if (
    modeCode === 'M100' ||
    modeCode === 'M300' ||
    modeCode === 'M500' || modeCode === 'M301'
  ) {
    let urlPara = getUrlParmByCode(paramList, token);
    paramList[0] && (paramList[0].value += urlPara);
    // 前端拼接了数据，原生不用再拼接
		paramList = paramList.slice(0, 1)
  }

  if (typeof paramList === 'string' && !paramList) {
    paramList = [];
  }

  return paramList;
}

function getUrlParmByCode(paramList, token) {
  if (paramList.length <= 1) return `?token=${token}`;
  let dataStr = '', list = [];
  let str = paramList.length > 0 && paramList[0].value.indexOf('?') > -1 ? '&' : '?';

  for (let i = 1; i < paramList.length; i++) {
    list.push(paramList[i].key + '=' + encodeURI(paramList[i].value));
  }
  dataStr = list.join('&');
	
  if (dataStr !== '') return `${str}${dataStr}&token=${token}`;
  return `${str}token=${token}`;
}

export const getConfigByEvtType = key => {
  return ENV_CONFIG[NUXT_ENV_APP][key];
}
export const getShareUrl = url => {
  return `${getConfigByEvtType('shareUrl')}${url}`;
}