import qs from 'qs';
import request from './api';

export const getHospital = async (params) => {
  let query = { pageNum: 1, pageSize: 1, ...params };
  const str = qs.stringify(query);
  
  return request({ url: `/api-ws/hospitals/?${str}` });
};

// 新的任务列表查询
export const getNewActivityDesc = async (data) => {
  const { id, token } = data;
  return request({
    url: `/campaign/tims/timsActivityInfo?activityId=${id}&token=${token}&setEntry=true`,
    headers: {
      token
    }
  });
}


// token校验
export const checkToken = async({token}) => {
  return request({
    url: `campaign/admin/task/checkToken?token=${token}`,
    withCredentials: true
  })
}

// 获取跳转链接
export const selectAppModuleParam = async ({id, token }) => {
  return request({
    url: `/contents/contentAppModule/selectAppModuleParam?id=${id}&token=${token}&setEntry=true`,
    withCredentials: true
  });
}

