const { NUXT_ENV_APP } = process.env;

export const BASE_URL = {
  dev: 'https://dev-sc.yunqueyi.com',
  test: 'https://test1-sc.yunqueyi.com',
  prod: 'https://sc.yunqueyi.com'  
};

export const API_CONFIG = {
  baseURL: BASE_URL[NUXT_ENV_APP],
  headers: {
    'X-Requested-With': 'XMLHttpRequest',
    'Content-Type': 'application/json;charset=UTF-8'
  },
  timeout: 10000,
  withCredentials: false,
  responseType: 'json',
  method: 'get'
}

export const REPONSE_CODE = {
  400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
  401: '用户没有权限（登录过期、token错误）',
  403: '用户得到授权，但是访问是被禁止的。',
  404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
  406: '请求的格式不可得。',
  410: '请求的资源被永久删除，且不会再得到的。',
  422: '当创建一个对象时，发生一个验证错误。',
  500: '服务器发生错误，请检查服务器。',
  502: '网关错误。',
  503: '服务不可用，服务器暂时过载或维护。',
  504: '网关超时。'
};

// 其他的域名 跳转
export const ENV_CONFIG = {
  dev: {
    apiUrl: 'https://dev-api.yunqueyi.com',
    shareUrl: 'https://dev-phome.yunqueyi.com',
    topicUrl: 'https://dev-phome.yunqueyi.com/discuss',
    appId: 'wxf4e66242d31c81c2', // 用于微信授权登录(张平)
    noticeUrl: 'https://dev-notice.yunqueyi.com',
    agreementUrl: "https://dev-scale.yunqueyi.com",
    beanCenterUrl: "https://dev-phome.yunqueyi.com/integral/#/chirpCenter"

  },
  test: {
    apiUrl: 'https://test1-api.yunqueyi.com',
    shareUrl: 'https://test1-phome.yunqueyi.com',
    topicUrl: 'https://test1-phome.yunqueyi.com/discuss',
    appId: 'wxebc0cc65cca7694b', // 用于微信授权登录(李军)
    noticeUrl: 'https://test1-notice.yunqueyi.com',
    agreementUrl: "https://test1-scale.yunqueyi.com",
    beanCenterUrl: "https://test1-phome.yunqueyi.com/integral/#/chirpCenter"
  },
  uat: {
    apiUrl: 'https://uat-api.yunqueyi.com',
    shareUrl: 'https://uat-phome.yunqueyi.com',
    topicUrl: 'https://uat-phome.yunqueyi.com/discuss',
    appId: 'wx342ef0e5afee54a7', // 用于微信授权登录(于蛟)
    noticeUrl: 'https://uat-notice.yunqueyi.com',
    agreementUrl: "https://uat-scale.yunqueyi.com",
    beanCenterUrl: "https://uat-phome.yunqueyi.com/integral/#/chirpCenter"
  },
  prod: {
    apiUrl: 'https://api.yunqueyi.com',
    shareUrl: 'https://phome.yunqueyi.com',
    topicUrl: 'https://phome.yunqueyi.com/discuss',
    appId: 'wx2c577552a2d28550', // 用于微信授权登录
    noticeUrl: 'https://notice.yunqueyi.com',
    agreementUrl: "https://scale.yunqueyi.com",
    beanCenterUrl: "https://phome.yunqueyi.com/integral/#/chirpCenter"
  }
}

