import qs from 'qs';
import request from './api';

export const getHospital = async (params) => {
  let query = { pageNum: 1, pageSize: 1, ...params };
  const str = qs.stringify(query);
  
  return request({ url: `/api-ws/hospitals/?${str}` });
};

// 新的任务列表查询
export const getNewActivityDesc = async (data) => {
  const { id, token } = data;
  return request({
    url: `/campaign/tims/timsActivityInfo?activityId=${id}&token=${token}&setEntry=true`,
    headers: {
      token
    }
  });
}


// token校验
export const checkToken = async({token}) => {
  return request({
    url: `campaign/admin/task/checkToken?token=${token}`,
    withCredentials: true
  })
}

// 获取跳转链接
export const selectAppModuleParam = async ({id, token }) => {
  return request({
    url: `/contents/contentAppModule/selectAppModuleParam?id=${id}&token=${token}&setEntry=true`,
    withCredentials: true
  });
}

// 活动首页个人信息
export const getSelfAllScore = async (data) => {
  const { id, token } = data;
  return request({
    url: `campaign/rank/getTimsRankAndScore?activityId=${id}&token=${token}&setEntry=true`,
    headers: {
      token
    }
  });
}

// 个人明细
export const getSelfActivity = async (data) => {
  const { id, token } = data;
  return request({
    url: `/campaign/tims/personalDetails?activityId=${id}&token=${token}&setEntry=true`,
    headers: {
      token
    }
  });
}

// 个人排行榜
export const getRankData = async (data) => {
  const { id } = data;
  return request({
    url: `campaign/rank/getTimsRankTop?activityId=${id}&topN=100`
  })
}

// 获取图形验证码
export const getCaptchaGet = async () => {
  return request({
    url: `account/account/captcha`,
    method: 'get'
  })
}

// 获取公钥
export const getPublicKey = async () => {
  return request({
    url: `account/cipher/key`,
    method: 'get'
  })
}

// 获取短信验证码
export const getAuthCode = (data) => {
  return request({
    url: `account/account/authCode`,
    method: 'post',
    data: data,
  })
}

// 获取加密过后的id
export const getEncryptId = () => {
	return request({
    url: `campaign/inviteDetail/vinci`,
    method: 'get',
    withCredentials: true,
  })
}

// 获取时间
export const getActivityTime = () => {
	return request({
    url: `campaign/tims/getTodayDate`,
    method: 'get'
  })
}

// 第一次进入活动接口需要调的接口
export const checkFirstEnter = ( data ) => {
  return request({
    url: `/campaign/homepage/firstInPage?activityId=${data.activityId}`,
    method: 'post',
    withCredentials: true
  })
}
// 获取用户拆红包接口及插红包的结果
export const getCarveStatus = ( data ) => {
  return request({
    url: `/campaign/redPackets/grantRedPackets`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}
// 判断用户是否已经拆红包
export const getRedPacketsLog = ( params ) => {
  return request({
    url: `/campaign/redPackets/getRedPacketsLog`,
    params: params,
    withCredentials: true
  })
}

// 登录点赞
export const pointResult = ( data ) => {
  return request({
    url: `/campaign/like/like`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}

// 点赞后进入活动主页
export const inviteFirstEnter = ( data ) => {
  return request({
    url: `/campaign/like/activePage `,
    method: 'post',
    data: data,
    withCredentials: true
  })
}