import qs from 'qs';
import request from './api';

export const getHospital = async (params) => {
  let query = { pageNum: 1, pageSize: 1, ...params };
  const str = qs.stringify(query);
  
  return request({ url: `/api-ws/hospitals/?${str}` });
};

export const getNcovRealReports = async (pageSize) => {
  return request({ url: `ncov/ncovPage/realReports?pageSize=${pageSize}` });
};

// 新的任务列表查询
export const getNewActivityDesc = async (data) => {
  const { id, token } = data;
  return request({
    url: `/campaign/tims/timsActivityInfo?activityId=${id}&token=${token}&setEntry=true`,
    headers: {
      token
    }
  });
}