
export const getSearchByName = name => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};

export const getItem = name => {
  if (!name) return;
  const v = sessionStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};

export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  sessionStorage.setItem(name, value);
};

export const removeItem = name => {
  if (!name) return;
  sessionStorage.removeItem(name);
};

export const setCookie = (cname,cvalue, exdays = 7, domain = '.yunqueyi.com') => { //yunqueyi.com
  let d = new Date(), expires = '';
  
  if (NUXT_ENV_APP === 'dev') {
    domain = window.location.hostname;  
  }
  d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
  expires = `expires=${d.toUTCString()}`;
  
  document.cookie = `${cname}=${cvalue};path=/;${expires};domain=${domain}`;
}

export const getCookie = (cname) => {
  const reg = new RegExp('(^| )' + cname + '=([^;]*)(;|$)');
  const arr = document.cookie.match(reg);

  return arr ? unescape(arr[2]) : null;
}


export const delCookie = (cname) => {
  var exp = new Date();
        exp.setTime(exp.getTime() - 1);
        var cval = getCookie(cname);
        
        if(cval!=null){
            document.cookie = 'token=; path=/; expires=' + new Date(0).toUTCString();
            document.cookie = 'token=; path=/; domain=.yunqueyi.com; expires=' + new Date(0).toUTCString();
            //document.cookie= name + "="+cval+";path=/;expires="+exp.toGMTString() + ";domain=" + domain;
        } 
}

export const getConfigByEvtType = key => {
  return ENV_CONFIG[NUXT_ENV_APP][key];
}
export const getShareUrl = url => {
  return `${getConfigByEvtType('shareUrl')}${url}`;
}